/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.provider;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.constant.EncryptDistSQLConstants;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;

public final class EncryptRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<EncryptRuleConfiguration> {
    public String convert(EncryptRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder("CREATE ENCRYPT RULE");
        Iterator iterator = ruleConfig.getTables().iterator();
        while (iterator.hasNext()) {
            EncryptTableRuleConfiguration tableRuleConfig = (EncryptTableRuleConfiguration)iterator.next();
            result.append(String.format(EncryptDistSQLConstants.ENCRYPT, tableRuleConfig.getName(), this.getEncryptColumns(tableRuleConfig.getColumns(), ruleConfig.getEncryptors())));
            if (!iterator.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        result.append(";");
        return result.toString();
    }

    private String getEncryptColumns(Collection<EncryptColumnRuleConfiguration> ruleConfigs, Map<String, AlgorithmConfiguration> encryptors) {
        StringBuilder result = new StringBuilder();
        Iterator<EncryptColumnRuleConfiguration> iterator = ruleConfigs.iterator();
        while (iterator.hasNext()) {
            EncryptColumnRuleConfiguration columnRuleConfig = iterator.next();
            result.append(String.format("(NAME=%s, %s, %s)", columnRuleConfig.getName(), this.getColumns(columnRuleConfig), this.getEncryptAlgorithms(columnRuleConfig, encryptors)));
            if (!iterator.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        return result.toString();
    }

    private String getColumns(EncryptColumnRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        String cipherColumnName = ruleConfig.getCipher().getName();
        if (!Strings.isNullOrEmpty((String)cipherColumnName)) {
            result.append(String.format("CIPHER=%s", cipherColumnName));
        }
        if (ruleConfig.getAssistedQuery().isPresent()) {
            result.append(",").append(' ').append(String.format("ASSISTED_QUERY_COLUMN=%s", ((EncryptColumnItemRuleConfiguration)ruleConfig.getAssistedQuery().get()).getName()));
        }
        if (ruleConfig.getLikeQuery().isPresent()) {
            result.append(",").append(' ').append(String.format("LIKE_QUERY_COLUMN=%s", ((EncryptColumnItemRuleConfiguration)ruleConfig.getLikeQuery().get()).getName()));
        }
        return result.toString();
    }

    private String getEncryptAlgorithms(EncryptColumnRuleConfiguration ruleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        StringBuilder result = new StringBuilder();
        String cipherEncryptorName = ruleConfig.getCipher().getEncryptorName();
        String assistedQueryEncryptorName = ruleConfig.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("");
        String likeQueryEncryptorName = ruleConfig.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("");
        if (!Strings.isNullOrEmpty((String)cipherEncryptorName)) {
            result.append(String.format("ENCRYPT_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)encryptors.get(cipherEncryptorName))));
        }
        if (!Strings.isNullOrEmpty((String)assistedQueryEncryptorName)) {
            result.append(",").append(' ').append(String.format("ASSISTED_QUERY_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)encryptors.get(assistedQueryEncryptorName))));
        }
        if (!Strings.isNullOrEmpty((String)likeQueryEncryptorName)) {
            result.append(",").append(' ').append(String.format("LIKE_QUERY_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)encryptors.get(likeQueryEncryptorName))));
        }
        return result.toString();
    }

    public Class<EncryptRuleConfiguration> getType() {
        return EncryptRuleConfiguration.class;
    }
}

