/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.encrypt.distsql.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

@DistSQLExecutorCurrentRuleRequired(value=EncryptRule.class)
public final class DropEncryptRuleExecutor
implements DatabaseRuleDropExecutor<DropEncryptRuleStatement, EncryptRule, EncryptRuleConfiguration> {
    private ShardingSphereDatabase database;
    private EncryptRule rule;

    public void checkBeforeUpdate(DropEncryptRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkToBeDroppedEncryptTableNames(sqlStatement);
        }
    }

    private void checkToBeDroppedEncryptTableNames(DropEncryptRuleStatement sqlStatement) {
        Collection currentEncryptTableNames = this.rule.getConfiguration().getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedTableNames.isEmpty(), () -> new MissingRequiredRuleException("Encrypt", this.database.getName(), notExistedTableNames));
    }

    public boolean hasAnyOneToBeDropped(DropEncryptRuleStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getTables());
    }

    public EncryptRuleConfiguration buildToBeDroppedRuleConfiguration(DropEncryptRuleStatement sqlStatement) {
        LinkedList<EncryptTableRuleConfiguration> toBeDroppedTables = new LinkedList<EncryptTableRuleConfiguration>();
        HashMap toBeDroppedEncryptors = new HashMap();
        for (String each2 : sqlStatement.getTables()) {
            toBeDroppedTables.add(new EncryptTableRuleConfiguration(each2, Collections.emptyList()));
            this.dropRule(each2);
        }
        UnusedAlgorithmFinder.findUnusedEncryptor(this.rule.getConfiguration()).forEach(each -> toBeDroppedEncryptors.put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getEncryptors().get(each)));
        return new EncryptRuleConfiguration(toBeDroppedTables, toBeDroppedEncryptors);
    }

    private void dropRule(String ruleName) {
        Optional<EncryptTableRuleConfiguration> encryptTableRuleConfig = this.rule.getConfiguration().getTables().stream().filter(each -> each.getName().equals(ruleName)).findAny();
        encryptTableRuleConfig.ifPresent(optional -> this.rule.getConfiguration().getTables().remove(encryptTableRuleConfig.get()));
    }

    public Class<EncryptRule> getRuleClass() {
        return EncryptRule.class;
    }

    public Class<DropEncryptRuleStatement> getType() {
        return DropEncryptRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(EncryptRule rule) {
        this.rule = rule;
    }
}

