/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnItemSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.CountEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.CreateEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptDistSQLStatementVisitor
extends EncryptDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateEncryptRule(EncryptDistSQLStatementParser.CreateEncryptRuleContext ctx) {
        return new CreateEncryptRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterEncryptRule(EncryptDistSQLStatementParser.AlterEncryptRuleContext ctx) {
        return new AlterEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropEncryptRule(EncryptDistSQLStatementParser.DropEncryptRuleContext ctx) {
        return new DropEncryptRuleStatement(null != ctx.ifExists(), (Collection)ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowEncryptRules(EncryptDistSQLStatementParser.ShowEncryptRulesContext ctx) {
        return new ShowEncryptRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitEncryptRuleDefinition(EncryptDistSQLStatementParser.EncryptRuleDefinitionContext ctx) {
        return new EncryptRuleSegment(this.getIdentifierValue((ParseTree)ctx.tableName()), (Collection)ctx.encryptColumnDefinition().stream().map(each -> (EncryptColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitEncryptColumnDefinition(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        return new EncryptColumnSegment(this.getIdentifierValue((ParseTree)ctx.columnDefinition().columnName()), new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.cipherColumnDefinition().cipherColumnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.encryptAlgorithm().algorithmDefinition())), null == ctx.assistedQueryColumnDefinition() ? null : new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.assistedQueryColumnDefinition().assistedQueryColumnName()), this.getAssistedEncryptor(ctx)), null == ctx.likeQueryColumnDefinition() ? null : new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.likeQueryColumnDefinition().likeQueryColumnName()), this.getLikeEncryptor(ctx)));
    }

    private AlgorithmSegment getAssistedEncryptor(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        return null == ctx.assistedQueryAlgorithm() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.assistedQueryAlgorithm().algorithmDefinition());
    }

    private AlgorithmSegment getLikeEncryptor(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        return null == ctx.likeQueryAlgorithm() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.likeQueryAlgorithm().algorithmDefinition());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(EncryptDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    private Properties getProperties(EncryptDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (EncryptDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableName(EncryptDistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitDatabaseName(EncryptDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitCountEncryptRule(EncryptDistSQLStatementParser.CountEncryptRuleContext ctx) {
        return new CountEncryptRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }
}

