/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;

public final class EncryptAlgorithmMetaData {
    private final PhysicalSchemaMetaData schemaMetaData;
    private final EncryptRule encryptRule;
    private final SelectStatementContext selectStatementContext;

    public Optional<EncryptAlgorithm> findEncryptor(int columnIndex) {
        List expandProjections = this.selectStatementContext.getProjectionsContext().getExpandProjections();
        if (expandProjections.isEmpty()) {
            return Optional.empty();
        }
        return this.findEncryptor(columnIndex, expandProjections);
    }

    private Optional<EncryptAlgorithm> findEncryptor(int columnIndex, List<Projection> expandProjections) {
        Projection projection = expandProjections.get(columnIndex - 1);
        if (projection instanceof ColumnProjection) {
            String columnName = ((ColumnProjection)projection).getName();
            Optional tableName = this.selectStatementContext.getTablesContext().findTableName((ColumnProjection)projection, this.schemaMetaData);
            return tableName.isPresent() ? this.findEncryptor((String)tableName.get(), columnName) : this.findEncryptor(columnName);
        }
        return Optional.empty();
    }

    private Optional<EncryptAlgorithm> findEncryptor(String tableName, String columnName) {
        return this.encryptRule.findEncryptor(tableName, columnName);
    }

    private Optional<EncryptAlgorithm> findEncryptor(String columnName) {
        for (String each : this.selectStatementContext.getTablesContext().getTableNames()) {
            Optional result = this.encryptRule.findEncryptor(each, columnName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Generated
    public EncryptAlgorithmMetaData(PhysicalSchemaMetaData schemaMetaData, EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        this.schemaMetaData = schemaMetaData;
        this.encryptRule = encryptRule;
        this.selectStatementContext = selectStatementContext;
    }
}

