/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.context;

import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriterBuilder;
import org.apache.shardingsphere.encrypt.rewrite.token.EncryptTokenGenerateBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.route.context.RouteContext;

public final class EncryptSQLRewriteContextDecorator
implements SQLRewriteContextDecorator<EncryptRule> {
    public void decorate(EncryptRule encryptRule, ConfigurationProperties props, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        boolean isQueryWithCipherColumn = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.QUERY_WITH_CIPHER_COLUMN);
        for (ParameterRewriter each : new EncryptParameterRewriterBuilder(encryptRule, isQueryWithCipherColumn).getParameterRewriters(sqlRewriteContext.getSchemaMetaData())) {
            if (sqlRewriteContext.getParameters().isEmpty() || !each.isNeedRewrite(sqlRewriteContext.getSqlStatementContext())) continue;
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
        sqlRewriteContext.addSQLTokenGenerators(new EncryptTokenGenerateBuilder(encryptRule, isQueryWithCipherColumn).getSQLTokenGenerators());
    }

    public int getOrder() {
        return 50;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

