/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.sm.algorithm;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.algorithm.EncryptAlgorithmInitializationException;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class SM3EncryptAlgorithm
implements StandardEncryptAlgorithm<Object, String> {
    private static final String SM3_SALT = "sm3-salt";
    private static final int SALT_LENGTH = 8;
    private byte[] sm3Salt;

    public void init(Properties props) {
        this.sm3Salt = this.createSm3Salt(props);
    }

    private byte[] createSm3Salt(Properties props) {
        String salt = null == props.getProperty(SM3_SALT) ? "" : String.valueOf(props.getProperty(SM3_SALT));
        ShardingSpherePreconditions.checkState((salt.isEmpty() || 8 == salt.length() ? 1 : 0) != 0, () -> new EncryptAlgorithmInitializationException("SM3", "Salt should be either blank or better 8 bytes long."));
        return salt.isEmpty() ? new byte[]{} : salt.getBytes(StandardCharsets.UTF_8);
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        return null == plainValue ? null : ByteUtils.toHexString((byte[])this.digest(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8), this.sm3Salt));
    }

    public Object decrypt(String cipherValue, EncryptContext encryptContext) {
        return cipherValue;
    }

    private byte[] digest(byte[] input, byte[] salt) {
        SM3Digest sm3Digest = new SM3Digest();
        byte[] updateByte = this.concat(input, salt);
        sm3Digest.update(updateByte, 0, updateByte.length);
        byte[] result = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(result, 0);
        return result;
    }

    private byte[] concat(byte[] input, byte[] salt) {
        int inputLength = input.length;
        int saltLength = salt.length;
        byte[] result = new byte[inputLength + saltLength];
        System.arraycopy(input, 0, result, 0, inputLength);
        System.arraycopy(salt, 0, result, inputLength, saltLength);
        return result;
    }

    public String getType() {
        return "SM3";
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

