/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.context.authority;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.governance.context.authority.listener.event.AuthorityChangedEvent;
import org.apache.shardingsphere.infra.context.metadata.MetaDataAwareEventSubscriber;
import org.apache.shardingsphere.infra.context.metadata.MetaDataContexts;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class GovernanceAuthorityContext
implements MetaDataAwareEventSubscriber {
    private volatile MetaDataContexts metaDataContexts;

    @Subscribe
    public synchronized void renew(AuthorityChangedEvent event) {
        this.reloadAuthority(event.getUsers());
    }

    private void reloadAuthority(Collection<ShardingSphereUser> users) {
        Optional<AuthorityRule> authorityRule = this.metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof AuthorityRule).findAny().map(each -> (AuthorityRule)each);
        Preconditions.checkState((boolean)authorityRule.isPresent());
        authorityRule.get().refresh(this.metaDataContexts.getMetaDataMap(), users);
    }

    @Generated
    public void setMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }
}

