/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.context.metadata;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.api.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.governance.context.authority.listener.event.AuthorityChangedEvent;
import org.apache.shardingsphere.governance.core.GovernanceFacade;
import org.apache.shardingsphere.governance.core.lock.ShardingSphereDistributeLock;
import org.apache.shardingsphere.governance.core.registry.config.event.datasource.DataSourceChangeCompletedEvent;
import org.apache.shardingsphere.governance.core.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.governance.core.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.governance.core.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.governance.core.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.governance.core.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.governance.core.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.governance.core.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.governance.core.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.governance.core.registry.state.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.governance.core.schema.GovernanceSchema;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.metadata.MetaDataContexts;
import org.apache.shardingsphere.infra.context.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.infra.context.metadata.impl.StandardMetaDataContexts;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.lock.InnerLockReleasedEvent;
import org.apache.shardingsphere.infra.lock.LockNameUtil;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUsers;
import org.apache.shardingsphere.infra.optimize.context.OptimizeContextFactory;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.ShardingSphereRulesBuilder;
import org.apache.shardingsphere.infra.rule.event.RuleChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceEvent;
import org.apache.shardingsphere.infra.rule.type.StatusContainedRule;
import org.apache.shardingsphere.infra.state.StateContext;

public final class GovernanceMetaDataContexts
implements MetaDataContexts {
    private final GovernanceFacade governanceFacade;
    private volatile StandardMetaDataContexts metaDataContexts;
    private final ShardingSphereLock lock;

    public GovernanceMetaDataContexts(StandardMetaDataContexts metaDataContexts, GovernanceFacade governanceFacade) {
        this.governanceFacade = governanceFacade;
        this.metaDataContexts = metaDataContexts;
        ShardingSphereEventBus.getInstance().register((Object)this);
        this.disableDataSources();
        this.persistMetaData();
        this.lock = this.createShardingSphereLock();
    }

    private void disableDataSources() {
        this.metaDataContexts.getMetaDataMap().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> this.disableDataSources((String)key, (StatusContainedRule)each)));
    }

    private void disableDataSources(String schemaName, StatusContainedRule rule) {
        Collection disabledDataSources = this.governanceFacade.getRegistryCenter().getDataSourceStatusService().loadDisabledDataSources(schemaName);
        disabledDataSources.stream().map(this::getDataSourceName).forEach(each -> rule.updateRuleStatus((RuleChangedEvent)new DataSourceNameDisabledEvent(each, true)));
    }

    private String getDataSourceName(String disabledDataSource) {
        return new GovernanceSchema(disabledDataSource).getDataSourceName();
    }

    private void persistMetaData() {
        this.metaDataContexts.getMetaDataMap().forEach((key, value) -> this.governanceFacade.getRegistryCenter().getSchemaService().persist(key, value.getSchema()));
    }

    private ShardingSphereLock createShardingSphereLock() {
        return (Boolean)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.LOCK_ENABLED) != false ? new ShardingSphereDistributeLock(this.governanceFacade.getRegistryCenterRepository(), ((Long)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.LOCK_WAIT_TIMEOUT_MILLISECONDS)).longValue()) : null;
    }

    public Collection<String> getAllSchemaNames() {
        return this.metaDataContexts.getAllSchemaNames();
    }

    public Map<String, ShardingSphereMetaData> getMetaDataMap() {
        return this.metaDataContexts.getMetaDataMap();
    }

    public ShardingSphereMetaData getMetaData(String schemaName) {
        return this.metaDataContexts.getMetaData(schemaName);
    }

    public ShardingSphereMetaData getDefaultMetaData() {
        return this.metaDataContexts.getDefaultMetaData();
    }

    public ShardingSphereRuleMetaData getGlobalRuleMetaData() {
        return this.metaDataContexts.getGlobalRuleMetaData();
    }

    public ExecutorEngine getExecutorEngine() {
        return this.metaDataContexts.getExecutorEngine();
    }

    public OptimizeContextFactory getOptimizeContextFactory() {
        return this.metaDataContexts.getOptimizeContextFactory();
    }

    public ConfigurationProperties getProps() {
        return this.metaDataContexts.getProps();
    }

    public Optional<ShardingSphereLock> getLock() {
        return Optional.ofNullable(this.lock);
    }

    public StateContext getStateContext() {
        return this.metaDataContexts.getStateContext();
    }

    public void close() {
        this.metaDataContexts.close();
        this.governanceFacade.close();
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) throws SQLException {
        HashMap<String, ShardingSphereMetaData> metaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
        metaDataMap.put(event.getSchemaName(), this.buildMetaData(event));
        this.metaDataContexts = new StandardMetaDataContexts(metaDataMap, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        this.governanceFacade.getRegistryCenter().getSchemaService().persist(event.getSchemaName(), ((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(event.getSchemaName())).getSchema());
        ShardingSphereEventBus.getInstance().post((Object)new DataSourceChangeCompletedEvent(event.getSchemaName(), ((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(event.getSchemaName())).getResource().getDatabaseType(), ((ShardingSphereMetaData)metaDataMap.get(event.getSchemaName())).getResource().getDataSources()));
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        HashMap metaDataMap = new HashMap(this.metaDataContexts.getMetaDataMap());
        metaDataMap.remove(event.getSchemaName());
        this.metaDataContexts = new StandardMetaDataContexts(metaDataMap, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        this.governanceFacade.getRegistryCenter().getSchemaService().delete(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        ConfigurationProperties props = new ConfigurationProperties(event.getProps());
        this.metaDataContexts = new StandardMetaDataContexts(this.getChangedMataDataMap(), this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), props);
    }

    @Subscribe
    public synchronized void renew(AuthorityChangedEvent event) {
        this.metaDataContexts = new StandardMetaDataContexts(this.metaDataContexts.getMetaDataMap(), this.getChangedGlobalRuleMetaData(event), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public synchronized void renew(SchemaChangedEvent event) {
        try {
            HashMap<String, ShardingSphereMetaData> newMetaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap().size(), 1.0f);
            for (Map.Entry entry : this.metaDataContexts.getMetaDataMap().entrySet()) {
                String schemaName = (String)entry.getKey();
                ShardingSphereMetaData oldMetaData = (ShardingSphereMetaData)entry.getValue();
                ShardingSphereMetaData newMetaData = event.getSchemaName().equals(schemaName) ? this.getChangedMetaData(oldMetaData, event.getSchema(), schemaName) : oldMetaData;
                newMetaDataMap.put(schemaName, newMetaData);
            }
            this.metaDataContexts = new StandardMetaDataContexts(newMetaDataMap, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        }
        finally {
            ShardingSphereEventBus.getInstance().post((Object)new InnerLockReleasedEvent(LockNameUtil.getMetadataRefreshLockName()));
        }
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) throws SQLException {
        HashMap<String, ShardingSphereMetaData> newMetaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
        String schemaName = event.getSchemaName();
        newMetaDataMap.remove(schemaName);
        newMetaDataMap.put(schemaName, this.getChangedMetaData((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(schemaName), event.getRuleConfigurations()));
        this.metaDataContexts = new StandardMetaDataContexts(newMetaDataMap, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        this.governanceFacade.getRegistryCenter().getSchemaService().persist(schemaName, ((ShardingSphereMetaData)newMetaDataMap.get(schemaName)).getSchema());
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        HashMap<String, ShardingSphereMetaData> newMetaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
        newMetaDataMap.remove(schemaName);
        newMetaDataMap.put(schemaName, this.getChangedMetaData((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(schemaName), event.getDataSourceConfigurations()));
        this.metaDataContexts = new StandardMetaDataContexts(newMetaDataMap, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        ShardingSphereEventBus.getInstance().post((Object)new DataSourceChangeCompletedEvent(event.getSchemaName(), ((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(event.getSchemaName())).getResource().getDatabaseType(), ((ShardingSphereMetaData)newMetaDataMap.get(event.getSchemaName())).getResource().getDataSources()));
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent event) {
        GovernanceSchema governanceSchema = event.getGovernanceSchema();
        Collection rules = ((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(governanceSchema.getSchemaName())).getRuleMetaData().getRules();
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof StatusContainedRule)) continue;
            ((StatusContainedRule)each).updateRuleStatus((RuleChangedEvent)new DataSourceNameDisabledEvent(governanceSchema.getDataSourceName(), event.isDisabled()));
        }
    }

    @Subscribe
    public synchronized void renew(PrimaryStateChangedEvent event) {
        GovernanceSchema governanceSchema = event.getGovernanceSchema();
        Collection rules = ((ShardingSphereMetaData)this.metaDataContexts.getMetaDataMap().get(governanceSchema.getSchemaName())).getRuleMetaData().getRules();
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof StatusContainedRule)) continue;
            ((StatusContainedRule)each).updateRuleStatus((RuleChangedEvent)new PrimaryDataSourceEvent(governanceSchema.getSchemaName(), governanceSchema.getDataSourceName(), event.getPrimaryDataSourceName()));
        }
    }

    @Subscribe
    public synchronized void renew(GlobalRuleConfigurationsChangedEvent event) {
        Collection newGlobalConfigs = event.getRuleConfigurations();
        if (!newGlobalConfigs.isEmpty()) {
            ShardingSphereRuleMetaData newGlobalRuleMetaData = new ShardingSphereRuleMetaData(newGlobalConfigs, ShardingSphereRulesBuilder.buildGlobalRules((Collection)newGlobalConfigs, (Map)this.metaDataContexts.getMetaDataMap()));
            this.metaDataContexts = new StandardMetaDataContexts(this.metaDataContexts.getMetaDataMap(), newGlobalRuleMetaData, this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getProps());
        }
    }

    private ShardingSphereMetaData buildMetaData(SchemaAddedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        if (!this.governanceFacade.getRegistryCenter().getDataSourceService().isExisted(schemaName)) {
            this.governanceFacade.getRegistryCenter().getDataSourceService().persist(schemaName, new LinkedHashMap());
        }
        if (!this.governanceFacade.getRegistryCenter().getSchemaRuleService().isExisted(schemaName)) {
            this.governanceFacade.getRegistryCenter().getSchemaRuleService().persist(schemaName, new LinkedList());
        }
        Map<String, Map<String, DataSource>> dataSourcesMap = this.createDataSourcesMap(Collections.singletonMap(schemaName, this.governanceFacade.getRegistryCenter().getDataSourceService().load(schemaName)));
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(dataSourcesMap, Collections.singletonMap(schemaName, this.governanceFacade.getRegistryCenter().getSchemaRuleService().load(schemaName)), this.governanceFacade.getRegistryCenter().getGlobalRuleService().load(), this.metaDataContexts.getProps().getProps());
        return (ShardingSphereMetaData)metaDataContextsBuilder.build().getMetaDataMap().get(schemaName);
    }

    private Map<String, ShardingSphereMetaData> getChangedMataDataMap() {
        HashMap<String, ShardingSphereMetaData> result = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap().size());
        for (Map.Entry entry : this.metaDataContexts.getMetaDataMap().entrySet()) {
            result.put((String)entry.getKey(), (ShardingSphereMetaData)entry.getValue());
        }
        return result;
    }

    private ShardingSphereMetaData getChangedMetaData(ShardingSphereMetaData oldMetaData, ShardingSphereSchema schema, String schemaName) {
        return new ShardingSphereMetaData(schemaName, oldMetaData.getResource(), oldMetaData.getRuleMetaData(), schema);
    }

    private ShardingSphereMetaData getChangedMetaData(ShardingSphereMetaData oldMetaData, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(oldMetaData.getName(), oldMetaData.getResource().getDataSources()), Collections.singletonMap(oldMetaData.getName(), ruleConfigs), new LinkedList(), this.metaDataContexts.getProps().getProps());
        return (ShardingSphereMetaData)builder.build().getMetaDataMap().values().iterator().next();
    }

    private ShardingSphereMetaData getChangedMetaData(ShardingSphereMetaData oldMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) throws SQLException {
        Collection<String> deletedDataSources = this.getDeletedDataSources(oldMetaData, newDataSourceConfigs);
        Map<String, DataSource> modifiedDataSources = this.getModifiedDataSources(oldMetaData, newDataSourceConfigs);
        oldMetaData.getResource().close(deletedDataSources);
        oldMetaData.getResource().close(modifiedDataSources.keySet());
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(oldMetaData.getName(), this.getNewDataSources(oldMetaData.getResource().getDataSources(), this.getAddedDataSources(oldMetaData, newDataSourceConfigs), modifiedDataSources, deletedDataSources));
        return (ShardingSphereMetaData)new MetaDataContextsBuilder(dataSourcesMap, Collections.singletonMap(oldMetaData.getName(), oldMetaData.getRuleMetaData().getConfigurations()), new LinkedList(), this.metaDataContexts.getProps().getProps()).build().getMetaDataMap().get(oldMetaData.getName());
    }

    private Map<String, DataSource> getNewDataSources(Map<String, DataSource> oldDataSources, Map<String, DataSource> addedDataSources, Map<String, DataSource> modifiedDataSources, Collection<String> deletedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(oldDataSources);
        result.keySet().removeAll(deletedDataSources);
        result.keySet().removeAll(modifiedDataSources.keySet());
        result.putAll(modifiedDataSources);
        result.putAll(addedDataSources);
        return result;
    }

    private Collection<String> getDeletedDataSources(ShardingSphereMetaData oldMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        LinkedList<String> result = new LinkedList<String>(oldMetaData.getResource().getDataSources().keySet());
        result.removeAll(newDataSourceConfigs.keySet());
        return result;
    }

    private Map<String, DataSource> getAddedDataSources(ShardingSphereMetaData oldMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        return DataSourceConverter.getDataSourceMap((Map)Maps.filterKeys(newDataSourceConfigs, each -> !oldMetaData.getResource().getDataSources().containsKey(each)));
    }

    private Map<String, DataSource> getModifiedDataSources(ShardingSphereMetaData oldMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        Map modifiedDataSourceConfigs = newDataSourceConfigs.entrySet().stream().filter(entry -> this.isModifiedDataSource(oldMetaData.getResource().getDataSources(), (String)entry.getKey(), (DataSourceConfiguration)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return DataSourceConverter.getDataSourceMap((Map)modifiedDataSourceConfigs);
    }

    private boolean isModifiedDataSource(Map<String, DataSource> oldDataSources, String newDataSourceName, DataSourceConfiguration newDataSourceConfig) {
        DataSourceConfiguration dataSourceConfig = (DataSourceConfiguration)DataSourceConverter.getDataSourceConfigurationMap(oldDataSources).get(newDataSourceName);
        return null != dataSourceConfig && !newDataSourceConfig.equals((Object)dataSourceConfig);
    }

    private Map<String, Map<String, DataSource>> createDataSourcesMap(Map<String, Map<String, DataSourceConfiguration>> dataSourcesConfigs) {
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(dataSourcesConfigs.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : dataSourcesConfigs.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceMap(entry.getValue()));
        }
        return result;
    }

    private ShardingSphereRuleMetaData getChangedGlobalRuleMetaData(AuthorityChangedEvent event) {
        Optional<AuthorityRuleConfiguration> authorityRuleConfig = this.metaDataContexts.getGlobalRuleMetaData().getConfigurations().stream().filter(each -> each instanceof AuthorityRuleConfiguration).findAny().map(each -> (AuthorityRuleConfiguration)each);
        if (!authorityRuleConfig.isPresent()) {
            return this.metaDataContexts.getGlobalRuleMetaData();
        }
        LinkedList<AuthorityRuleConfiguration> globalRuleConfigs = new LinkedList<AuthorityRuleConfiguration>(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations());
        globalRuleConfigs.remove(authorityRuleConfig.get());
        globalRuleConfigs.add(this.getChangedAuthorityRuleConfiguration(authorityRuleConfig.get(), event));
        return new ShardingSphereRuleMetaData(globalRuleConfigs, ShardingSphereRulesBuilder.buildGlobalRules(globalRuleConfigs, (Map)this.metaDataContexts.getMetaDataMap()));
    }

    private AuthorityRuleConfiguration getChangedAuthorityRuleConfiguration(AuthorityRuleConfiguration oldAuthorityRuleConfig, AuthorityChangedEvent event) {
        ShardingSphereUsers oldUsers = new ShardingSphereUsers(oldAuthorityRuleConfig.getUsers());
        HashSet<ShardingSphereUser> users = new HashSet<ShardingSphereUser>(this.getNewUsers(oldUsers, event.getUsers()));
        users.addAll(this.getModifiedUsers(oldUsers, event.getUsers()));
        return new AuthorityRuleConfiguration(users, oldAuthorityRuleConfig.getProvider());
    }

    private Collection<ShardingSphereUser> getNewUsers(ShardingSphereUsers oldUsers, Collection<ShardingSphereUser> users) {
        return users.stream().filter(each -> !oldUsers.findUser(each.getGrantee()).isPresent()).collect(Collectors.toSet());
    }

    private Collection<ShardingSphereUser> getModifiedUsers(ShardingSphereUsers oldUsers, Collection<ShardingSphereUser> users) {
        return users.stream().filter(each -> oldUsers.findUser(each.getGrantee()).isPresent()).collect(Collectors.toSet());
    }
}

