/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.context.transaction;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.shardingsphere.governance.core.registry.config.event.datasource.DataSourceChangeCompletedEvent;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;

public final class GovernanceTransactionContexts
implements TransactionContexts {
    private final TransactionContexts contexts;
    private final String xaTransactionMangerType;

    public GovernanceTransactionContexts(TransactionContexts contexts, String xaTransactionMangerType) {
        this.contexts = contexts;
        this.xaTransactionMangerType = xaTransactionMangerType;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    public Map<String, ShardingTransactionManagerEngine> getEngines() {
        return this.contexts.getEngines();
    }

    public ShardingTransactionManagerEngine getDefaultTransactionManagerEngine() {
        return this.contexts.getDefaultTransactionManagerEngine();
    }

    public void close() throws Exception {
        this.contexts.close();
    }

    @Subscribe
    public synchronized void renew(DataSourceChangeCompletedEvent event) throws Exception {
        ShardingTransactionManagerEngine oldEngine = (ShardingTransactionManagerEngine)this.contexts.getEngines().remove(event.getSchemaName());
        if (null != oldEngine) {
            oldEngine.close();
        }
        ShardingTransactionManagerEngine newEngine = new ShardingTransactionManagerEngine();
        newEngine.init(event.getDatabaseType(), event.getDataSources(), this.xaTransactionMangerType);
        this.contexts.getEngines().put(event.getSchemaName(), newEngine);
    }
}

