/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.checker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.executor.check.SQLCheckResult;
import org.apache.shardingsphere.infra.executor.check.SQLChecker;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;

public final class AuthorityChecker
implements SQLChecker<AuthorityRule> {
    public boolean check(String schemaName, Grantee grantee, AuthorityRule authorityRule) {
        if (null == grantee) {
            return true;
        }
        return authorityRule.findPrivileges(grantee).map(optional -> optional.hasPrivileges(schemaName)).orElse(false);
    }

    public SQLCheckResult check(SQLStatement sqlStatement, List<Object> parameters, Grantee grantee, String currentSchema, Map<String, ShardingSphereMetaData> metaDataMap, AuthorityRule authorityRule) {
        if (null == grantee) {
            return new SQLCheckResult(true, "");
        }
        Optional<ShardingSpherePrivileges> privileges = authorityRule.findPrivileges(grantee);
        return privileges.map(optional -> new SQLCheckResult(optional.hasPrivileges(Collections.singletonList(this.getPrivilege(sqlStatement))), "")).orElseGet(() -> new SQLCheckResult(false, ""));
    }

    public boolean check(Grantee grantee, AuthorityRule authorityRule) {
        return authorityRule.findUser(grantee).isPresent();
    }

    public boolean check(Grantee grantee, BiPredicate<Object, Object> validator, Object cipher, AuthorityRule authorityRule) {
        Optional<ShardingSphereUser> user = authorityRule.findUser(grantee);
        if (user.isPresent()) {
            return validator.test(user.get(), cipher);
        }
        return false;
    }

    private PrivilegeType getPrivilege(SQLStatement sqlStatement) {
        if (sqlStatement instanceof MySQLShowDatabasesStatement) {
            return PrivilegeType.SHOW_DB;
        }
        return null;
    }

    public int getOrder() {
        return 500;
    }

    public Class<AuthorityRule> getTypeClass() {
        return AuthorityRule.class;
    }
}

