/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.builder;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.authority.provider.natived.builder.StoragePrivilegeHandler;
import org.apache.shardingsphere.authority.provider.natived.builder.StoragePrivilegeMerger;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.NativePrivileges;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.typed.TypedSPIRegistry;

public final class StoragePrivilegeBuilder {
    private static final int CPU_CORES = Runtime.getRuntime().availableProcessors();
    private static final long FUTURE_GET_TIME_OUT_MILLISECONDS = 5000L;

    public static Map<ShardingSphereUser, NativePrivileges> build(Collection<ShardingSphereMetaData> metaDataList, Collection<ShardingSphereUser> users) {
        return metaDataList.isEmpty() ? StoragePrivilegeBuilder.buildPrivilegesInCache(users) : StoragePrivilegeBuilder.buildPrivilegesInStorage(metaDataList, users);
    }

    private static Map<ShardingSphereUser, NativePrivileges> buildPrivilegesInCache(Collection<ShardingSphereUser> users) {
        LinkedHashMap<ShardingSphereUser, NativePrivileges> result = new LinkedHashMap<ShardingSphereUser, NativePrivileges>(users.size(), 1.0f);
        NativePrivileges privileges = new NativePrivileges();
        privileges.setSuperPrivilege();
        users.forEach(each -> result.put((ShardingSphereUser)each, privileges));
        return result;
    }

    private static Map<ShardingSphereUser, NativePrivileges> buildPrivilegesInStorage(Collection<ShardingSphereMetaData> metaDataList, Collection<ShardingSphereUser> users) {
        LinkedHashMap<ShardingSphereUser, NativePrivileges> result = new LinkedHashMap<ShardingSphereUser, NativePrivileges>(users.size(), 1.0f);
        metaDataList.stream().map(each -> StoragePrivilegeBuilder.buildPrivilegesInStorage(each, users)).forEach(result::putAll);
        return result;
    }

    private static Map<ShardingSphereUser, NativePrivileges> buildPrivilegesInStorage(ShardingSphereMetaData metaData, Collection<ShardingSphereUser> users) {
        DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType((Collection)metaData.getResource().getAllInstanceDataSources());
        Optional handler = TypedSPIRegistry.findRegisteredService(StoragePrivilegeHandler.class, (String)databaseType.getName(), (Properties)new Properties());
        if (!handler.isPresent()) {
            return StoragePrivilegeBuilder.buildPrivilegesInCache(users);
        }
        StoragePrivilegeBuilder.save(metaData.getResource().getAllInstanceDataSources(), users, (StoragePrivilegeHandler)handler.get());
        Map<ShardingSphereUser, Collection<NativePrivileges>> result = StoragePrivilegeBuilder.load(metaData.getResource().getAllInstanceDataSources(), users, (StoragePrivilegeHandler)handler.get());
        StoragePrivilegeBuilder.checkConsistent(result);
        return StoragePrivilegeMerger.merge(result, metaData.getName(), (Collection<ShardingSphereRule>)metaData.getRuleMetaData().getRules());
    }

    private static void save(Collection<DataSource> dataSources, Collection<ShardingSphereUser> users, StoragePrivilegeHandler handler) {
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(CPU_CORES * 2, dataSources.isEmpty() ? 1 : dataSources.size()));
        HashSet tasks = new HashSet();
        for (DataSource each2 : dataSources) {
            tasks.add(executorService.submit(() -> StoragePrivilegeBuilder.save(each2, users, handler)));
        }
        tasks.forEach(each -> {
            try {
                each.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new IllegalStateException(String.format("Error while loading privilege with %s", each), ex);
            }
        });
        executorService.shutdownNow();
    }

    private static void save(DataSource dataSource, Collection<ShardingSphereUser> users, StoragePrivilegeHandler handler) {
        try {
            Collection<ShardingSphereUser> noneExisted = handler.diff(users, dataSource);
            if (!noneExisted.isEmpty()) {
                handler.create(noneExisted, dataSource);
                handler.grantAll(noneExisted, dataSource);
            }
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
    }

    private static Map<ShardingSphereUser, Collection<NativePrivileges>> load(Collection<DataSource> dataSources, Collection<ShardingSphereUser> users, StoragePrivilegeHandler handler) {
        LinkedHashMap<ShardingSphereUser, Collection<NativePrivileges>> result = new LinkedHashMap<ShardingSphereUser, Collection<NativePrivileges>>(users.size(), 1.0f);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(CPU_CORES * 2, dataSources.isEmpty() ? 1 : dataSources.size()));
        HashSet<Future<Map>> futures = new HashSet<Future<Map>>(dataSources.size(), 1.0f);
        for (DataSource each2 : dataSources) {
            futures.add(executorService.submit(() -> handler.load(users, each2)));
        }
        futures.forEach(each -> {
            try {
                StoragePrivilegeBuilder.fillPrivileges(result, each);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new IllegalStateException(String.format("Error while loading privilege with %s", each), ex);
            }
        });
        executorService.shutdownNow();
        return result;
    }

    private static void fillPrivileges(Map<ShardingSphereUser, Collection<NativePrivileges>> userPrivilegeMap, Future<Map<ShardingSphereUser, NativePrivileges>> future) throws InterruptedException, ExecutionException, TimeoutException {
        for (Map.Entry<ShardingSphereUser, NativePrivileges> entry : future.get(5000L, TimeUnit.MILLISECONDS).entrySet()) {
            if (!userPrivilegeMap.containsKey(entry.getKey())) {
                userPrivilegeMap.put(entry.getKey(), new LinkedHashSet());
            }
            userPrivilegeMap.get(entry.getKey()).add(entry.getValue());
        }
    }

    private static void checkConsistent(Map<ShardingSphereUser, Collection<NativePrivileges>> userPrivilegeMap) {
        userPrivilegeMap.forEach(StoragePrivilegeBuilder::checkConsistent);
    }

    private static void checkConsistent(ShardingSphereUser user, Collection<NativePrivileges> privileges) {
        NativePrivileges sample = privileges.iterator().next();
        Preconditions.checkState((boolean)privileges.stream().allMatch(each -> each.equals(sample)), (String)"Different physical instances have different privileges for user %s", (Object)user.getGrantee().toString().replaceAll("%", "%%"));
    }

    @Generated
    private StoragePrivilegeBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(StoragePrivilegeHandler.class);
    }
}

