/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.NativePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.SchemaPrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.TablePrivileges;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.DataNodeContainedRule;

public final class StoragePrivilegeMerger {
    public static Map<ShardingSphereUser, NativePrivileges> merge(Map<ShardingSphereUser, Collection<NativePrivileges>> privileges, String schemaName, Collection<ShardingSphereRule> rules) {
        HashMap<ShardingSphereUser, NativePrivileges> result = new HashMap<ShardingSphereUser, NativePrivileges>(privileges.size(), 1.0f);
        for (Map.Entry<ShardingSphereUser, Collection<NativePrivileges>> entry : privileges.entrySet()) {
            result.put(entry.getKey(), StoragePrivilegeMerger.merge(entry.getValue(), schemaName, rules));
        }
        return result;
    }

    private static NativePrivileges merge(Collection<NativePrivileges> privileges, String schemaName, Collection<ShardingSphereRule> rules) {
        return privileges.isEmpty() ? new NativePrivileges() : StoragePrivilegeMerger.getMergedPrivileges(privileges.iterator().next(), schemaName, rules);
    }

    private static NativePrivileges getMergedPrivileges(NativePrivileges privilege, String schemaName, Collection<ShardingSphereRule> rules) {
        NativePrivileges result = new NativePrivileges();
        result.getAdministrativePrivileges().getPrivileges().addAll(privilege.getAdministrativePrivileges().getPrivileges());
        result.getDatabasePrivileges().getGlobalPrivileges().addAll(privilege.getDatabasePrivileges().getGlobalPrivileges());
        result.getDatabasePrivileges().getSpecificPrivileges().putAll(StoragePrivilegeMerger.getMergedSchemaPrivileges(privilege, schemaName, rules));
        return result;
    }

    private static Map<String, SchemaPrivileges> getMergedSchemaPrivileges(NativePrivileges privilege, String schemaName, Collection<ShardingSphereRule> rules) {
        HashMap<String, SchemaPrivileges> result = new HashMap<String, SchemaPrivileges>(privilege.getDatabasePrivileges().getSpecificPrivileges().size(), 1.0f);
        for (Map.Entry<String, SchemaPrivileges> entry : privilege.getDatabasePrivileges().getSpecificPrivileges().entrySet()) {
            if (result.containsKey(schemaName)) continue;
            SchemaPrivileges schemaPrivileges = new SchemaPrivileges(schemaName);
            schemaPrivileges.getGlobalPrivileges().addAll(entry.getValue().getGlobalPrivileges());
            schemaPrivileges.getSpecificPrivileges().putAll(StoragePrivilegeMerger.getMergedTablePrivileges(entry.getValue(), rules));
            result.put(schemaName, schemaPrivileges);
        }
        return result;
    }

    private static Map<String, TablePrivileges> getMergedTablePrivileges(SchemaPrivileges privilege, Collection<ShardingSphereRule> rules) {
        HashMap<String, TablePrivileges> result = new HashMap<String, TablePrivileges>(privilege.getSpecificPrivileges().size(), 1.0f);
        for (Map.Entry<String, TablePrivileges> entry : privilege.getSpecificPrivileges().entrySet()) {
            Optional<String> logicalTable = StoragePrivilegeMerger.findLogicalTable(entry, rules);
            if (!logicalTable.isPresent() || result.containsKey(logicalTable.get())) continue;
            result.put(logicalTable.get(), new TablePrivileges(logicalTable.get(), entry.getValue().getPrivileges()));
        }
        return result;
    }

    private static Optional<String> findLogicalTable(Map.Entry<String, TablePrivileges> privilege, Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            Optional logicalTable;
            if (!(each instanceof DataNodeContainedRule) || !(logicalTable = ((DataNodeContainedRule)each).findLogicTableByActualTable(privilege.getKey())).isPresent()) continue;
            return logicalTable;
        }
        return Optional.empty();
    }

    @Generated
    private StoragePrivilegeMerger() {
    }
}

