/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.rule;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.authority.api.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.spi.AuthorityProvideAlgorithm;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.level.KernelRule;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class AuthorityRule
implements KernelRule,
GlobalRule {
    private final AuthorityProvideAlgorithm provider;
    private final Collection<ShardingSphereUser> users;

    public AuthorityRule(AuthorityRuleConfiguration config, Map<String, ShardingSphereMetaData> mataDataMap, Collection<ShardingSphereUser> users) {
        this.provider = (AuthorityProvideAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)config.getProvider(), AuthorityProvideAlgorithm.class);
        this.provider.init(mataDataMap, users);
        this.users = users;
    }

    public Optional<ShardingSpherePrivileges> findPrivileges(Grantee grantee) {
        return this.provider.findPrivileges(grantee);
    }

    public void refresh(Map<String, ShardingSphereMetaData> mataDataMap, Collection<ShardingSphereUser> users) {
        this.provider.refresh(mataDataMap, users);
        this.users.clear();
        this.users.addAll(users);
    }

    public Optional<ShardingSphereUser> findUser(Grantee grantee) {
        return this.users.stream().filter(user -> user.getGrantee().equals((Object)grantee)).findFirst();
    }

    static {
        ShardingSphereServiceLoader.register(AuthorityProvideAlgorithm.class);
    }
}

