/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.yaml.swapper;

import java.util.Collection;
import org.apache.shardingsphere.authority.api.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.metadata.user.yaml.config.YamlUsersConfigurationConverter;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;

public final class AuthorityRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlAuthorityRuleConfiguration, AuthorityRuleConfiguration> {
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlAuthorityRuleConfiguration swapToYamlConfiguration(AuthorityRuleConfiguration data) {
        YamlAuthorityRuleConfiguration result = new YamlAuthorityRuleConfiguration();
        result.setProvider(this.algorithmSwapper.swapToYamlConfiguration(data.getProvider()));
        result.setUsers(YamlUsersConfigurationConverter.convertYamlUserConfigurations((Collection)data.getUsers()));
        return result;
    }

    public AuthorityRuleConfiguration swapToObject(YamlAuthorityRuleConfiguration yamlConfig) {
        Collection users = YamlUsersConfigurationConverter.convertShardingSphereUser(yamlConfig.getUsers());
        return new AuthorityRuleConfiguration(users, this.algorithmSwapper.swapToObject(yamlConfig.getProvider()));
    }

    public Class<AuthorityRuleConfiguration> getTypeClass() {
        return AuthorityRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "AUTHORITY";
    }

    public int getOrder() {
        return 500;
    }
}

