/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.table;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> tables;

    public TablesContext(SimpleTableSegment tableSegment) {
        this(null == tableSegment ? Collections.emptyList() : Collections.singletonList(tableSegment));
    }

    public TablesContext(Collection<SimpleTableSegment> tableSegments) {
        HashMap<String, SimpleTableSegment> tableMaps = new HashMap<String, SimpleTableSegment>(1, 1.0f);
        LinkedList<SimpleTableSegment> actualTables = new LinkedList<SimpleTableSegment>();
        for (SimpleTableSegment each : tableSegments) {
            if (tableMaps.containsKey(each.getTableName().getIdentifier().getValue())) continue;
            tableMaps.put(each.getTableName().getIdentifier().getValue(), each);
            actualTables.add(each);
        }
        this.tables = actualTables;
    }

    public Collection<String> getTableNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.tables.size(), 1.0f);
        for (SimpleTableSegment each : this.tables) {
            result.add(each.getTableName().getIdentifier().getValue());
        }
        return result;
    }

    public Optional<String> findTableName(ColumnSegment column, PhysicalSchemaMetaData schemaMetaData) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (column.getOwner().isPresent()) {
            return Optional.of(this.findTableNameFromSQL(((OwnerSegment)column.getOwner().get()).getIdentifier().getValue()));
        }
        return this.findTableNameFromMetaData(column.getIdentifier().getValue(), schemaMetaData);
    }

    public Optional<String> findTableName(ColumnProjection column, PhysicalSchemaMetaData schemaMetaData) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (null != column.getOwner()) {
            return Optional.of(this.findTableNameFromSQL(column.getOwner()));
        }
        return this.findTableNameFromMetaData(column.getName(), schemaMetaData);
    }

    public String findTableNameFromSQL(String tableNameOrAlias) {
        for (SimpleTableSegment each : this.tables) {
            if (!tableNameOrAlias.equalsIgnoreCase(each.getTableName().getIdentifier().getValue()) && !tableNameOrAlias.equals(each.getAlias().orElse(null))) continue;
            return each.getTableName().getIdentifier().getValue();
        }
        throw new IllegalStateException("Can not find owner from table.");
    }

    private Optional<String> findTableNameFromMetaData(String columnName, PhysicalSchemaMetaData schemaMetaData) {
        for (SimpleTableSegment each : this.tables) {
            if (!schemaMetaData.containsColumn(each.getTableName().getIdentifier().getValue(), columnName)) continue;
            return Optional.of(each.getTableName().getIdentifier().getValue());
        }
        return Optional.empty();
    }

    @Generated
    public Collection<SimpleTableSegment> getTables() {
        return this.tables;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.getTables() + ")";
    }
}

