/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereSegmentExtractUtils;

public final class SelectStatementContext
extends CommonSQLStatementContext<SelectStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext = new TablesContext(this.getSimpleTableSegments());
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final boolean containsSubquery;

    public SelectStatementContext(SelectStatement sqlStatement, GroupByContext groupByContext, OrderByContext orderByContext, ProjectionsContext projectionsContext, PaginationContext paginationContext) {
        super(sqlStatement);
        this.groupByContext = groupByContext;
        this.orderByContext = orderByContext;
        this.projectionsContext = projectionsContext;
        this.paginationContext = paginationContext;
        this.containsSubquery = this.containsSubquery();
    }

    public SelectStatementContext(PhysicalSchemaMetaData schemaMetaData, List<Object> parameters, SelectStatement sqlStatement) {
        super(sqlStatement);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(schemaMetaData).createProjectionsContext(this.getSimpleTableSegments(), ((SelectStatement)this.getSqlStatement()).getProjections(), this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters);
        this.containsSubquery = this.containsSubquery();
    }

    private boolean containsSubquery() {
        Collection subqueryPredicateSegments = WhereSegmentExtractUtils.getSubqueryWhereSegments((SelectStatement)((SelectStatement)this.getSqlStatement()));
        for (WhereSegment each : subqueryPredicateSegments) {
            if (null == each) continue;
            return true;
        }
        return false;
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(((TextOrderByItemSegment)each.getSegment()).getText()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(String name) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtil.getExactlyValue((String)name);
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase(each.getAlias().orElse(null))) continue;
            return Optional.of(rawName);
        }
        return Optional.empty();
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof ColumnOrderByItemSegment ? ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue() : ((ExpressionOrderByItemSegment)orderByItemSegment).getExpression();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((SelectStatement)this.getSqlStatement()).getWhere();
    }

    public Collection<SimpleTableSegment> getSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public boolean isContainsSubquery() {
        return this.containsSubquery;
    }
}

