/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class RowNumberPaginationContextEngine {
    private static final Collection<String> ROW_NUMBER_IDENTIFIERS = new HashSet<String>();

    public PaginationContext createPaginationContext(ExpressionSegment where, ProjectionsContext projectionsContext, List<Object> parameters) {
        Optional<String> rowNumberAlias = this.isRowNumberAlias(projectionsContext);
        if (!rowNumberAlias.isPresent()) {
            return new PaginationContext(null, null, parameters);
        }
        Collection andPredicates = new ExpressionBuilder(where).extractAndPredicates().getAndPredicates();
        Collection<BinaryOperationExpression> rowNumberPredicates = this.getRowNumberPredicates(andPredicates, rowNumberAlias.get());
        return rowNumberPredicates.isEmpty() ? new PaginationContext(null, null, parameters) : this.createPaginationWithRowNumber(rowNumberPredicates, parameters);
    }

    private Collection<BinaryOperationExpression> getRowNumberPredicates(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        LinkedList<BinaryOperationExpression> result = new LinkedList<BinaryOperationExpression>();
        for (AndPredicate each : andPredicates) {
            for (ExpressionSegment expression : each.getPredicates()) {
                if (!this.isRowNumberColumn(expression, rowNumberAlias) || !this.isCompareCondition(expression)) continue;
                result.add((BinaryOperationExpression)expression);
            }
        }
        return result;
    }

    private Optional<String> isRowNumberAlias(ProjectionsContext projectionsContext) {
        for (String each : ROW_NUMBER_IDENTIFIERS) {
            Optional<String> result = projectionsContext.findAlias(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private boolean isRowNumberColumn(ExpressionSegment predicate, String rowNumberAlias) {
        if (predicate instanceof BinaryOperationExpression) {
            ExpressionSegment left = ((BinaryOperationExpression)predicate).getLeft();
            return left instanceof ColumnSegment ? ROW_NUMBER_IDENTIFIERS.contains(((ColumnSegment)left).getIdentifier().getValue()) || ((ColumnSegment)left).getIdentifier().getValue().equalsIgnoreCase(rowNumberAlias) : false;
        }
        return false;
    }

    private boolean isCompareCondition(ExpressionSegment predicate) {
        if (predicate instanceof BinaryOperationExpression) {
            String operator = ((BinaryOperationExpression)predicate).getOperator();
            return "<".equals(operator) || "<=".equals(operator) || ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private PaginationContext createPaginationWithRowNumber(Collection<BinaryOperationExpression> rowNumberPredicates, List<Object> parameters) {
        RowNumberValueSegment offset = null;
        RowNumberValueSegment rowCount = null;
        for (BinaryOperationExpression each : rowNumberPredicates) {
            String operator;
            switch (operator = each.getOperator()) {
                case ">": {
                    offset = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case ">=": {
                    offset = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
                case "<": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case "<=": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
            }
        }
        return new PaginationContext((PaginationValueSegment)offset, (PaginationValueSegment)rowCount, parameters);
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        return expression instanceof LiteralExpressionSegment ? new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, (long)((Integer)((LiteralExpressionSegment)expression).getLiterals()).intValue(), boundOpened) : new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
    }

    static {
        ROW_NUMBER_IDENTIFIERS.add("rownum");
        ROW_NUMBER_IDENTIFIERS.add("ROW_NUMBER");
    }
}

