/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.table;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> tables;

    public TablesContext(SimpleTableSegment tableSegment) {
        this(null == tableSegment ? Collections.emptyList() : Collections.singletonList(tableSegment));
    }

    public TablesContext(Collection<SimpleTableSegment> tableSegments) {
        LinkedList<SimpleTableSegment> actualTables = new LinkedList<SimpleTableSegment>(tableSegments);
        HashSet tableSets = new HashSet(actualTables.size(), 1.0f);
        actualTables.removeIf(each -> !tableSets.add(each.getTableName().getIdentifier().getValue()));
        this.tables = actualTables;
    }

    public Collection<String> getTableNames() {
        return this.tables.stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toSet());
    }

    public Optional<String> findTableName(ColumnSegment column, ShardingSphereSchema schema) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (column.getOwner().isPresent()) {
            return this.findTableNameFromSQL(((OwnerSegment)column.getOwner().get()).getIdentifier().getValue());
        }
        return this.findTableNameFromMetaData(column.getIdentifier().getValue(), schema);
    }

    public Optional<String> findTableName(ColumnProjection column, ShardingSphereSchema schema) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (null != column.getOwner()) {
            return this.findTableNameFromSQL(column.getOwner());
        }
        return this.findTableNameFromMetaData(column.getName(), schema);
    }

    public Optional<String> findTableNameFromSQL(String tableNameOrAlias) {
        for (SimpleTableSegment each : this.tables) {
            if (!tableNameOrAlias.equalsIgnoreCase(each.getTableName().getIdentifier().getValue()) && !tableNameOrAlias.equals(each.getAlias().orElse(null))) continue;
            return Optional.of(each.getTableName().getIdentifier().getValue());
        }
        return Optional.empty();
    }

    private Optional<String> findTableNameFromMetaData(String columnName, ShardingSphereSchema schema) {
        for (SimpleTableSegment each : this.tables) {
            if (!schema.containsColumn(each.getTableName().getIdentifier().getValue(), columnName)) continue;
            return Optional.of(each.getTableName().getIdentifier().getValue());
        }
        return Optional.empty();
    }

    @Generated
    public Collection<SimpleTableSegment> getTables() {
        return this.tables;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.getTables() + ")";
    }
}

