/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.having.HavingColumn;
import org.apache.shardingsphere.infra.binder.segment.select.having.HavingContext;
import org.apache.shardingsphere.infra.binder.segment.select.having.engine.HavingContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereSegmentExtractUtils;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class SelectStatementContext
extends CommonSQLStatementContext<SelectStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext = new TablesContext(this.getAllSimpleTableSegments());
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final HavingContext havingContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final boolean containsSubquery;
    private final int generateOrderByStartIndex;

    public SelectStatementContext(SelectStatement sqlStatement, GroupByContext groupByContext, OrderByContext orderByContext, ProjectionsContext projectionsContext, PaginationContext paginationContext) {
        super(sqlStatement);
        this.groupByContext = groupByContext;
        this.havingContext = new HavingContextEngine().createHavingContext(sqlStatement);
        this.orderByContext = orderByContext;
        this.projectionsContext = projectionsContext;
        this.paginationContext = paginationContext;
        this.containsSubquery = this.containsSubquery();
        this.generateOrderByStartIndex = this.generateOrderByStartIndex();
    }

    public SelectStatementContext(ShardingSphereSchema schema, List<Object> parameters, SelectStatement sqlStatement) {
        super(sqlStatement);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.havingContext = new HavingContextEngine().createHavingContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(schema, sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(schema).createProjectionsContext(this.getFromSimpleTableSegments(), ((SelectStatement)this.getSqlStatement()).getProjections(), this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters);
        this.containsSubquery = this.containsSubquery();
        this.generateOrderByStartIndex = this.generateOrderByStartIndex();
    }

    private boolean containsSubquery() {
        Collection subqueryPredicateSegments = WhereSegmentExtractUtils.getSubqueryWhereSegments((SelectStatement)((SelectStatement)this.getSqlStatement()));
        for (WhereSegment each : subqueryPredicateSegments) {
            if (null == each) continue;
            return true;
        }
        return false;
    }

    private int generateOrderByStartIndex() {
        SelectStatement sqlStatement = (SelectStatement)this.getSqlStatement();
        int stopIndex = SelectStatementHandler.getWindowSegment((SelectStatement)sqlStatement).isPresent() ? ((WindowSegment)SelectStatementHandler.getWindowSegment((SelectStatement)sqlStatement).get()).getStopIndex() : (sqlStatement.getHaving().isPresent() ? ((HavingSegment)sqlStatement.getHaving().get()).getStopIndex() : (sqlStatement.getGroupBy().isPresent() ? ((GroupBySegment)sqlStatement.getGroupBy().get()).getStopIndex() : (sqlStatement.getWhere().isPresent() ? ((WhereSegment)sqlStatement.getWhere().get()).getStopIndex() : this.getAllSimpleTableSegments().stream().mapToInt(SimpleTableSegment::getStopIndex).max().orElse(0))));
        return stopIndex + 1;
    }

    public boolean isContainsJoinQuery() {
        return ((SelectStatement)this.getSqlStatement()).getFrom() instanceof JoinTableSegment;
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
        this.setIndexForHaving(columnLabelIndexMap);
    }

    private void setIndexForHaving(Map<String, Integer> columnLabelIndexMap) {
        for (HavingColumn each : this.havingContext.getColumns()) {
            String columnLabel = each.getSegment().getIdentifier().getValue();
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s.", (Object)each);
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(((TextOrderByItemSegment)each.getSegment()).getText()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(String name) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtil.getExactlyValue((String)name);
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase(each.getAlias().orElse(null))) continue;
            return Optional.of(rawName);
        }
        return Optional.empty();
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof ColumnOrderByItemSegment ? ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue() : ((ExpressionOrderByItemSegment)orderByItemSegment).getExpression();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((SelectStatement)this.getSqlStatement()).getWhere();
    }

    public Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    public Collection<SimpleTableSegment> getFromSimpleTableSegments() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        TableExtractor extractor = new TableExtractor();
        result.addAll(extractor.extractTablesWithFromClause((SelectStatement)this.getSqlStatement()));
        result.addAll(this.getTemporarySimpleTableSegments(extractor.getTableContext()));
        return result;
    }

    private Collection<SimpleTableSegment> getTemporarySimpleTableSegments(Collection<TableSegment> tableSegments) {
        return tableSegments.stream().filter(each -> each instanceof SubqueryTableSegment).map(each -> new SimpleTableSegment(each.getStartIndex(), each.getStopIndex(), new IdentifierValue(each.getAlias().orElse("")))).collect(Collectors.toList());
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public HavingContext getHavingContext() {
        return this.havingContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public boolean isContainsSubquery() {
        return this.containsSubquery;
    }

    @Generated
    public int getGenerateOrderByStartIndex() {
        return this.generateOrderByStartIndex;
    }
}

