/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class ProjectionEngine {
    private final ShardingSphereSchema schema;
    private final DatabaseType databaseType;
    private int aggregationAverageDerivedColumnCount;
    private int aggregationDistinctDerivedColumnCount;

    public Optional<Projection> createProjection(TableSegment table, ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return Optional.of(this.createProjection(table, (ShorthandProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return Optional.of(this.createProjection((ColumnProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            return Optional.of(this.createProjection((ExpressionProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationDistinctProjectionSegment) {
            return Optional.of(this.createProjection((AggregationDistinctProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationProjectionSegment) {
            return Optional.of(this.createProjection((AggregationProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            return Optional.of(this.createProjection((SubqueryProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.createProjection((ParameterMarkerExpressionSegment)projectionSegment));
        }
        return Optional.empty();
    }

    private ParameterMarkerProjection createProjection(ParameterMarkerExpressionSegment projectionSegment) {
        return new ParameterMarkerProjection(projectionSegment.getParameterMarkerIndex(), projectionSegment.getParameterMarkerType(), projectionSegment.getAlias().orElse(null));
    }

    private SubqueryProjection createProjection(SubqueryProjectionSegment projectionSegment) {
        return new SubqueryProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private ShorthandProjection createProjection(TableSegment table, ShorthandProjectionSegment projectionSegment) {
        String owner = projectionSegment.getOwner().map(ownerSegment -> ownerSegment.getIdentifier().getValue()).orElse(null);
        LinkedHashSet<ColumnProjection> columnProjections = new LinkedHashSet<ColumnProjection>();
        columnProjections.addAll(this.getShorthandColumnsFromSimpleTableSegment(table, owner));
        columnProjections.addAll(this.getShorthandColumnsFromSubqueryTableSegment(table));
        columnProjections.addAll(this.getShorthandColumnsFromJoinTableSegment(table, (ProjectionSegment)projectionSegment));
        return new ShorthandProjection(owner, columnProjections);
    }

    private ColumnProjection createProjection(ColumnProjectionSegment projectionSegment) {
        String owner = projectionSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)projectionSegment.getColumn().getOwner().get()).getIdentifier().getValue() : null;
        return new ColumnProjection(owner, projectionSegment.getColumn().getIdentifier().getValue(), projectionSegment.getAlias().orElse(null));
    }

    private ExpressionProjection createProjection(ExpressionProjectionSegment projectionSegment) {
        return new ExpressionProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private AggregationDistinctProjection createProjection(AggregationDistinctProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        String alias = projectionSegment.getAlias().orElse(DerivedColumn.AGGREGATION_DISTINCT_DERIVED.getDerivedColumnAlias(this.aggregationDistinctDerivedColumnCount++));
        AggregationDistinctProjection result = new AggregationDistinctProjection(projectionSegment.getStartIndex(), projectionSegment.getStopIndex(), projectionSegment.getType(), innerExpression, alias, projectionSegment.getDistinctExpression(), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDistinctDerivedProjection(result);
        }
        return result;
    }

    private AggregationProjection createProjection(AggregationProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        AggregationProjection result = new AggregationProjection(projectionSegment.getType(), innerExpression, projectionSegment.getAlias().orElse(null), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDerivedProjection(result);
        }
        return result;
    }

    private Collection<ColumnProjection> getShorthandColumnsFromSimpleTableSegment(TableSegment table, String owner) {
        if (!(table instanceof SimpleTableSegment)) {
            return Collections.emptyList();
        }
        String tableName = ((SimpleTableSegment)table).getTableName().getIdentifier().getValue();
        String tableAlias = table.getAlias().orElse(tableName);
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        if (null == owner) {
            this.schema.getAllColumnNames(tableName).stream().map(columnName -> new ColumnProjection(tableAlias, (String)columnName, null)).forEach(result::add);
        } else if (owner.equalsIgnoreCase(tableAlias)) {
            this.schema.getAllColumnNames(tableName).stream().map(columnName -> new ColumnProjection(owner, (String)columnName, null)).forEach(result::add);
        }
        return result;
    }

    private Collection<ColumnProjection> getShorthandColumnsFromSubqueryTableSegment(TableSegment table) {
        if (!(table instanceof SubqueryTableSegment)) {
            return Collections.emptyList();
        }
        SelectStatement subSelectStatement = ((SubqueryTableSegment)table).getSubquery().getSelect();
        Collection projections = subSelectStatement.getProjections().getProjections().stream().map(each -> this.createProjection(subSelectStatement.getFrom(), (ProjectionSegment)each).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        return this.getColumnProjections(projections);
    }

    private Collection<ColumnProjection> getShorthandColumnsFromJoinTableSegment(TableSegment table, ProjectionSegment projectionSegment) {
        if (!(table instanceof JoinTableSegment)) {
            return Collections.emptyList();
        }
        LinkedList<Projection> projections = new LinkedList<Projection>();
        this.createProjection(((JoinTableSegment)table).getLeft(), projectionSegment).ifPresent(projections::add);
        this.createProjection(((JoinTableSegment)table).getRight(), projectionSegment).ifPresent(projections::add);
        return this.getColumnProjections(projections);
    }

    private Collection<ColumnProjection> getColumnProjections(Collection<Projection> projections) {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        for (Projection each : projections) {
            if (each instanceof ColumnProjection) {
                result.add((ColumnProjection)each);
            }
            if (!(each instanceof ShorthandProjection)) continue;
            result.addAll(((ShorthandProjection)each).getActualColumns().values());
        }
        return result;
    }

    private void appendAverageDistinctDerivedProjection(AggregationDistinctProjection averageDistinctProjection) {
        String innerExpression = averageDistinctProjection.getInnerExpression();
        String distinctInnerExpression = averageDistinctProjection.getDistinctInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection countDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.COUNT, innerExpression, countAlias, distinctInnerExpression, this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection sumDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.SUM, innerExpression, sumAlias, distinctInnerExpression, this.databaseType);
        averageDistinctProjection.getDerivedAggregationProjections().add(countDistinctProjection);
        averageDistinctProjection.getDerivedAggregationProjections().add(sumDistinctProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    private void appendAverageDerivedProjection(AggregationProjection averageProjection) {
        String innerExpression = averageProjection.getInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection countProjection = new AggregationProjection(AggregationType.COUNT, innerExpression, countAlias, this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection sumProjection = new AggregationProjection(AggregationType.SUM, innerExpression, sumAlias, this.databaseType);
        averageProjection.getDerivedAggregationProjections().add(countProjection);
        averageProjection.getDerivedAggregationProjections().add(sumProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    @Generated
    public ProjectionEngine(ShardingSphereSchema schema, DatabaseType databaseType) {
        this.schema = schema;
        this.databaseType = databaseType;
    }
}

