/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.decider.engine;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.decider.SQLFederationDecider;
import org.apache.shardingsphere.infra.binder.decider.SQLFederationDeciderFactory;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtil;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class SQLFederationDeciderEngine {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLFederationDecider> deciders;

    public SQLFederationDeciderEngine(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        this.deciders = SQLFederationDeciderFactory.getInstances(rules);
    }

    public SQLFederationDeciderContext decide(QueryContext queryContext, ShardingSphereDatabase database) {
        SQLFederationDeciderContext result = new SQLFederationDeciderContext();
        SQLStatementContext<?> sqlStatementContext = queryContext.getSqlStatementContext();
        if (this.isSelectStatementContainsSystemSchema(sqlStatementContext, database)) {
            result.setUseSQLFederation(true);
            return result;
        }
        String sqlFederationType = (String)this.props.getValue((Enum)ConfigurationPropertyKey.SQL_FEDERATION_TYPE);
        if ("NONE".equals(sqlFederationType) || !(sqlStatementContext instanceof SelectStatementContext)) {
            return result;
        }
        for (Map.Entry<ShardingSphereRule, SQLFederationDecider> entry : this.deciders.entrySet()) {
            if (result.isUseSQLFederation()) continue;
            entry.getValue().decide(result, queryContext, database, entry.getKey(), this.props);
        }
        return result;
    }

    private boolean isSelectStatementContainsSystemSchema(SQLStatementContext<?> sqlStatementContext, ShardingSphereDatabase database) {
        return sqlStatementContext instanceof SelectStatementContext && SystemSchemaUtil.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), sqlStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database);
    }
}

