/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.hint.SQLHintExtractor;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.OracleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.SQL92Statement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.SQLServerStatement;

public class CommonSQLStatementContext<T extends SQLStatement>
implements SQLStatementContext<T> {
    private final T sqlStatement;
    private final TablesContext tablesContext;
    private final DatabaseType databaseType;
    private final SQLHintExtractor sqlHintExtractor;

    public CommonSQLStatementContext(T sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.databaseType = this.getDatabaseType((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(Collections.emptyList(), this.databaseType);
        this.sqlHintExtractor = new SQLHintExtractor(sqlStatement);
    }

    private DatabaseType getDatabaseType(SQLStatement sqlStatement) {
        if (sqlStatement instanceof MySQLStatement) {
            return DatabaseTypeFactory.getInstance((String)"MySQL");
        }
        if (sqlStatement instanceof PostgreSQLStatement) {
            return DatabaseTypeFactory.getInstance((String)"PostgreSQL");
        }
        if (sqlStatement instanceof OracleStatement) {
            return DatabaseTypeFactory.getInstance((String)"Oracle");
        }
        if (sqlStatement instanceof SQLServerStatement) {
            return DatabaseTypeFactory.getInstance((String)"SQLServer");
        }
        if (sqlStatement instanceof SQL92Statement) {
            return DatabaseTypeFactory.getInstance((String)"SQL92");
        }
        if (sqlStatement instanceof OpenGaussStatement) {
            return DatabaseTypeFactory.getInstance((String)"openGauss");
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    public boolean isHintWriteRouteOnly() {
        return this.sqlHintExtractor.isHintWriteRouteOnly();
    }

    public Comparable<?> getHintShardingDatabaseValue(String tableName) {
        return this.sqlHintExtractor.getHintShardingDatabaseValue(tableName);
    }

    public Comparable<?> getHintShardingTableValue(String tableName) {
        return this.sqlHintExtractor.getHintShardingTableValue(tableName);
    }

    public boolean containsHintShardingDatabaseValue(String tableName) {
        return this.sqlHintExtractor.containsHintShardingDatabaseValue(tableName);
    }

    public boolean containsHintShardingTableValue(String tableName) {
        return this.sqlHintExtractor.containsHintShardingTableValue(tableName);
    }

    public boolean containsHintShardingValue(String tableName) {
        return this.containsHintShardingDatabaseValue(tableName) || this.containsHintShardingTableValue(tableName);
    }

    @Override
    @Generated
    public T getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public SQLHintExtractor getSqlHintExtractor() {
        return this.sqlHintExtractor;
    }
}

