/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.RenameTableStatement;

public final class RenameTableStatementContext
extends CommonSQLStatementContext<RenameTableStatement>
implements TableAvailable {
    private final TablesContext tablesContext;

    public RenameTableStatementContext(RenameTableStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getRenameTables().stream().map(RenameTableDefinitionSegment::getRenameTable).collect(Collectors.toList()), this.getDatabaseType());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (RenameTableDefinitionSegment each : ((RenameTableStatement)this.getSqlStatement()).getRenameTables()) {
            result.add(each.getTable());
            result.add(each.getRenameTable());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

