/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;

public final class DeleteStatementContext
extends CommonSQLStatementContext<DeleteStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext;
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();

    public DeleteStatementContext(DeleteStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments(), this.getDatabaseType());
        ((DeleteStatement)this.getSqlStatement()).getWhere().ifPresent(this.whereSegments::add);
        ColumnExtractor.extractColumnSegments(this.columnSegments, this.whereSegments);
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromDelete((DeleteStatement)this.getSqlStatement());
        return this.filterAliasDeleteTable(tableExtractor.getRewriteTables());
    }

    private Collection<SimpleTableSegment> filterAliasDeleteTable(Collection<SimpleTableSegment> tableSegments) {
        HashMap aliasTableSegmentMap = new HashMap(tableSegments.size(), 1.0f);
        for (SimpleTableSegment each : tableSegments) {
            each.getAlias().ifPresent(optional -> aliasTableSegmentMap.putIfAbsent(optional, each));
        }
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (SimpleTableSegment each : tableSegments) {
            SimpleTableSegment aliasDeleteTable = (SimpleTableSegment)aliasTableSegmentMap.get(each.getTableName().getIdentifier().getValue());
            if (null != aliasDeleteTable && !aliasDeleteTable.equals(each)) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getTables();
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

