/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.impl;

import com.google.common.base.Strings;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OracleDatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SubqueryProjection
implements Projection {
    private final String expression;
    private final Projection projection;
    private final String alias;
    private final DatabaseType databaseType;

    @Override
    public Optional<String> getAlias() {
        return Strings.isNullOrEmpty((String)this.alias) ? this.buildDefaultAlias(this.databaseType) : Optional.of(this.alias);
    }

    private Optional<String> buildDefaultAlias(DatabaseType databaseType) {
        if (databaseType instanceof OracleDatabaseType) {
            return Optional.of(this.expression.replace(" ", "").toUpperCase());
        }
        return Optional.of(this.expression);
    }

    @Override
    public String getColumnLabel() {
        return this.getAlias().orElse(this.expression);
    }

    @Override
    public Projection cloneWithOwner(IdentifierValue ownerIdentifier) {
        return new SubqueryProjection(this.expression, this.projection, this.alias, this.databaseType);
    }

    @Generated
    public SubqueryProjection(String expression, Projection projection, String alias, DatabaseType databaseType) {
        this.expression = expression;
        this.projection = projection;
        this.alias = alias;
        this.databaseType = databaseType;
    }

    @Override
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Projection getProjection() {
        return this.projection;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubqueryProjection)) {
            return false;
        }
        SubqueryProjection other = (SubqueryProjection)o;
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Projection this$projection = this.getProjection();
        Projection other$projection = other.getProjection();
        if (this$projection == null ? other$projection != null : !this$projection.equals(other$projection)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Projection $projection = this.getProjection();
        result = result * 59 + ($projection == null ? 43 : $projection.hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubqueryProjection(expression=" + this.getExpression() + ", projection=" + this.getProjection() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ")";
    }
}

