/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ExpressionRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;

public final class RowNumberPaginationContextEngine {
    private static final Collection<String> ROW_NUMBER_IDENTIFIERS = new CaseInsensitiveSet(2, 1.0f);
    private static final Map<String, String> DATABASE_TYPE_ROW_NUMBER_IDENTIFIERS = new CaseInsensitiveMap(2, 1.0f);
    private final DatabaseType databaseType;

    public PaginationContext createPaginationContext(Collection<ExpressionSegment> expressions, ProjectionsContext projectionsContext, List<Object> params) {
        Optional<String> rowNumberAlias = this.findRowNumberAlias(projectionsContext);
        if (!rowNumberAlias.isPresent()) {
            return new PaginationContext(null, null, params);
        }
        Collection andPredicates = expressions.stream().flatMap(each -> ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each).stream()).collect(Collectors.toList());
        Collection<BinaryOperationExpression> rowNumberPredicates = this.getRowNumberPredicates(andPredicates, rowNumberAlias.get());
        return rowNumberPredicates.isEmpty() ? new PaginationContext(null, null, params) : this.createPaginationWithRowNumber(rowNumberPredicates, params);
    }

    private Collection<BinaryOperationExpression> getRowNumberPredicates(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        LinkedList<BinaryOperationExpression> result = new LinkedList<BinaryOperationExpression>();
        for (AndPredicate each : andPredicates) {
            for (ExpressionSegment expression : each.getPredicates()) {
                if (!this.isRowNumberColumn(expression, rowNumberAlias) || !this.isCompareCondition(expression)) continue;
                result.add((BinaryOperationExpression)expression);
            }
        }
        return result;
    }

    private Optional<String> findRowNumberAlias(ProjectionsContext projectionsContext) {
        for (String each : ROW_NUMBER_IDENTIFIERS) {
            Optional<String> result = projectionsContext.findAlias(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.ofNullable(DATABASE_TYPE_ROW_NUMBER_IDENTIFIERS.get(this.databaseType.getType()));
    }

    private boolean isRowNumberColumn(ExpressionSegment predicate, String rowNumberAlias) {
        if (predicate instanceof BinaryOperationExpression) {
            ExpressionSegment left = ((BinaryOperationExpression)predicate).getLeft();
            if (left instanceof ColumnSegment) {
                String leftColumnValue = ((ColumnSegment)left).getIdentifier().getValue();
                return ROW_NUMBER_IDENTIFIERS.contains(leftColumnValue) || leftColumnValue.equalsIgnoreCase(rowNumberAlias);
            }
            return false;
        }
        return false;
    }

    private boolean isCompareCondition(ExpressionSegment predicate) {
        if (predicate instanceof BinaryOperationExpression) {
            String operator = ((BinaryOperationExpression)predicate).getOperator();
            return "<".equals(operator) || "<=".equals(operator) || ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private PaginationContext createPaginationWithRowNumber(Collection<BinaryOperationExpression> rowNumberPredicates, List<Object> params) {
        RowNumberValueSegment offset = null;
        RowNumberValueSegment rowCount = null;
        for (BinaryOperationExpression each : rowNumberPredicates) {
            String operator;
            switch (operator = each.getOperator()) {
                case ">": {
                    offset = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case ">=": {
                    offset = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
                case "<": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case "<=": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
            }
        }
        return new PaginationContext((PaginationValueSegment)offset, (PaginationValueSegment)rowCount, params);
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        if (expression instanceof LiteralExpressionSegment) {
            return new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, Long.valueOf(Long.parseLong(((LiteralExpressionSegment)expression).getLiterals().toString())), boundOpened);
        }
        if (expression instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
        }
        return new ExpressionRowNumberValueSegment(startIndex, stopIndex, expression, boundOpened);
    }

    @Generated
    public RowNumberPaginationContextEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    static {
        ROW_NUMBER_IDENTIFIERS.add("ROWNUM");
        ROW_NUMBER_IDENTIFIERS.add("ROW_NUMBER");
        DATABASE_TYPE_ROW_NUMBER_IDENTIFIERS.put("Oracle", "ROWNUM");
        DATABASE_TYPE_ROW_NUMBER_IDENTIFIERS.put("SQLServer", "ROW_NUMBER");
    }
}

