/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.combine.CombineSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.lock.LockSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.projection.ProjectionsSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.where.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class SelectStatementBinder
implements SQLStatementBinder<SelectStatement> {
    private final Map<String, TableSegmentBinderContext> outerTableBinderContexts;

    public SelectStatementBinder() {
        this.outerTableBinderContexts = Collections.emptyMap();
    }

    @Override
    public SelectStatement bind(SelectStatement sqlStatement, SQLStatementBinderContext binderContext) {
        SelectStatement result = this.copy(sqlStatement);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        Optional<TableSegment> boundTableSegment = sqlStatement.getFrom().map(optional -> TableSegmentBinder.bind(optional, binderContext, tableBinderContexts, this.outerTableBinderContexts));
        boundTableSegment.ifPresent(arg_0 -> ((SelectStatement)result).setFrom(arg_0));
        result.setProjections(ProjectionsSegmentBinder.bind(sqlStatement.getProjections(), binderContext, (TableSegment)boundTableSegment.orElse(null), tableBinderContexts, this.outerTableBinderContexts));
        sqlStatement.getWhere().ifPresent(optional -> result.setWhere(WhereSegmentBinder.bind(optional, binderContext, tableBinderContexts, this.outerTableBinderContexts)));
        sqlStatement.getCombine().ifPresent(optional -> result.setCombine(CombineSegmentBinder.bind(optional, binderContext)));
        sqlStatement.getLock().ifPresent(optional -> result.setLock(LockSegmentBinder.bind(optional, binderContext, tableBinderContexts, this.outerTableBinderContexts)));
        return result;
    }

    private SelectStatement copy(SelectStatement sqlStatement) {
        SelectStatement result = (SelectStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        sqlStatement.getGroupBy().ifPresent(arg_0 -> ((SelectStatement)result).setGroupBy(arg_0));
        sqlStatement.getHaving().ifPresent(arg_0 -> ((SelectStatement)result).setHaving(arg_0));
        sqlStatement.getOrderBy().ifPresent(arg_0 -> ((SelectStatement)result).setOrderBy(arg_0));
        sqlStatement.getLimit().ifPresent(arg_0 -> ((SelectStatement)result).setLimit(arg_0));
        sqlStatement.getWindow().ifPresent(arg_0 -> ((SelectStatement)result).setWindow(arg_0));
        sqlStatement.getModelSegment().ifPresent(arg_0 -> ((SelectStatement)result).setModelSegment(arg_0));
        sqlStatement.getWithSegment().ifPresent(arg_0 -> ((SelectStatement)result).setWithSegment(arg_0));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    @Generated
    public SelectStatementBinder(Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        this.outerTableBinderContexts = outerTableBinderContexts;
    }
}

