/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class PostgreSQLDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 5432;
    private final String hostName;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Pattern pattern = Pattern.compile("jdbc:postgresql://([\\w\\-\\.]+):?([0-9]*)/([\\w\\-]+)", 2);

    public PostgreSQLDataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, this.pattern.pattern());
        }
        this.hostName = matcher.group(1);
        this.port = Strings.isNullOrEmpty((String)matcher.group(2)) ? 5432 : Integer.parseInt(matcher.group(2));
        this.catalog = matcher.group(3);
        this.schema = null;
    }

    @Override
    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

