/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeUtil;
import org.apache.shardingsphere.infra.rule.DataNodeRoutedRule;
import org.apache.shardingsphere.infra.rule.DataSourceRoutedRule;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;

    public Collection<DataNode> getDataNodes(String tableName) {
        Optional<DataNodeRoutedRule> dataNodeRoutedRule = this.rules.stream().filter(each -> each instanceof DataNodeRoutedRule).findFirst().map(rule -> (DataNodeRoutedRule)rule);
        if (!dataNodeRoutedRule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<DataNode> result = new LinkedList<DataNode>(dataNodeRoutedRule.get().getAllDataNodes().get(tableName));
        for (ShardingSphereRule each2 : this.rules) {
            if (!(each2 instanceof DataSourceRoutedRule)) continue;
            for (Map.Entry<String, Collection<String>> entry : ((DataSourceRoutedRule)each2).getDataSourceMapper().entrySet()) {
                Collection<DataNode> dataNodes = this.find(result, entry.getKey());
                result.removeAll(dataNodes);
                result.addAll(this.regenerate(dataNodes, entry.getValue()));
            }
        }
        return result;
    }

    private Collection<DataNode> find(Collection<DataNode> dataNodes, String logicDataSource) {
        return dataNodes.stream().filter(each -> each.getDataSourceName().equals(logicDataSource)).collect(Collectors.toList());
    }

    private Collection<DataNode> regenerate(Collection<DataNode> dataNodes, Collection<String> actualDataSources) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>();
        for (DataNode each : dataNodes) {
            result.addAll(this.regenerate(actualDataSources, each.getTableName()));
        }
        return result;
    }

    private Collection<DataNode> regenerate(Collection<String> dataSources, String table) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>(dataSources.size(), 1.0f);
        for (String each : dataSources) {
            result.add(new DataNode(each, table));
        }
        return result;
    }

    public Map<String, List<DataNode>> getDataNodeGroups(String tableName) {
        return DataNodeUtil.getDataNodeGroups(this.getDataNodes(tableName));
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }
}

