/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.column;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.handler.DatabaseMetaDataDialectHandler;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.handler.DatabaseMetaDataDialectHandlerFactory;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class PhysicalColumnMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static Collection<PhysicalColumnMetaData> load(Connection connection, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        LinkedList<PhysicalColumnMetaData> result = new LinkedList<PhysicalColumnMetaData>();
        Collection<String> primaryKeys = PhysicalColumnMetaDataLoader.loadPrimaryKeys(connection, tableNamePattern);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<Boolean> isPrimaryKeys = new ArrayList<Boolean>();
        ArrayList<Boolean> isCaseSensitives = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), tableNamePattern, "%");){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                if (!Objects.equals(tableNamePattern, tableName)) continue;
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypes.add(resultSet.getInt(DATA_TYPE));
                columnTypeNames.add(resultSet.getString(TYPE_NAME));
                isPrimaryKeys.add(primaryKeys.contains(columnName));
                columnNames.add(columnName);
            }
        }
        resultSet = connection.createStatement().executeQuery(PhysicalColumnMetaDataLoader.generateEmptyResultSQL(tableNamePattern, databaseType));
        var11_12 = null;
        try {
            for (String each : columnNames) {
                isCaseSensitives.add(resultSet.getMetaData().isCaseSensitive(resultSet.findColumn(each)));
            }
        }
        catch (Throwable throwable) {
            var11_12 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (var11_12 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        var11_12.addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add(new PhysicalColumnMetaData((String)columnNames.get(i), (Integer)columnTypes.get(i), (String)columnTypeNames.get(i), (Boolean)isPrimaryKeys.get(i), false, (Boolean)isCaseSensitives.get(i)));
        }
        return result;
    }

    private static String generateEmptyResultSQL(String table, DatabaseType databaseType) {
        QuoteCharacter quoteCharacter = DatabaseMetaDataDialectHandlerFactory.findHandler(databaseType).map(DatabaseMetaDataDialectHandler::getQuoteCharacter).orElse(QuoteCharacter.NONE);
        return String.format("SELECT * FROM %s WHERE 1 != 1", quoteCharacter.wrap(table));
    }

    private static Collection<String> loadPrimaryKeys(Connection connection, String table) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    @Generated
    private PhysicalColumnMetaDataLoader() {
    }
}

