/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.index;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.model.physical.model.index.PhysicalIndexMetaData;

public final class PhysicalIndexMetaDataLoader {
    private static final String INDEX_NAME = "INDEX_NAME";

    public static Collection<PhysicalIndexMetaData> load(Connection connection, String table) throws SQLException {
        HashSet<PhysicalIndexMetaData> result = new HashSet<PhysicalIndexMetaData>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), connection.getSchema(), table, false, false);){
            while (resultSet.next()) {
                String indexName = resultSet.getString(INDEX_NAME);
                if (null == indexName) continue;
                result.add(new PhysicalIndexMetaData(indexName));
            }
        }
        return result;
    }

    @Generated
    private PhysicalIndexMetaDataLoader() {
    }
}

