/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.index.PhysicalIndexMetaData;

public final class PhysicalTableMetaData {
    private final Map<String, PhysicalColumnMetaData> columns;
    private final Map<String, PhysicalIndexMetaData> indexes;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();

    public PhysicalTableMetaData() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public PhysicalTableMetaData(Collection<PhysicalColumnMetaData> columnMetaDataList, Collection<PhysicalIndexMetaData> indexMetaDataList) {
        this.columns = this.getColumns(columnMetaDataList);
        this.indexes = this.getIndexes(indexMetaDataList);
    }

    private Map<String, PhysicalColumnMetaData> getColumns(Collection<PhysicalColumnMetaData> columnMetaDataList) {
        LinkedHashMap<String, PhysicalColumnMetaData> result = new LinkedHashMap<String, PhysicalColumnMetaData>(columnMetaDataList.size(), 1.0f);
        for (PhysicalColumnMetaData each : columnMetaDataList) {
            String lowerColumnName = each.getName().toLowerCase();
            this.columnNames.add(lowerColumnName);
            result.put(lowerColumnName, each);
            if (!each.isPrimaryKey()) continue;
            this.primaryKeyColumns.add(lowerColumnName);
        }
        return Collections.synchronizedMap(result);
    }

    private Map<String, PhysicalIndexMetaData> getIndexes(Collection<PhysicalIndexMetaData> indexMetaDataList) {
        LinkedHashMap<String, PhysicalIndexMetaData> result = new LinkedHashMap<String, PhysicalIndexMetaData>(indexMetaDataList.size(), 1.0f);
        for (PhysicalIndexMetaData each : indexMetaDataList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return Collections.synchronizedMap(result);
    }

    public PhysicalColumnMetaData getColumnMetaData(int columnIndex) {
        return this.columns.get(this.columnNames.get(columnIndex));
    }

    public int findColumnIndex(String columnName) {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (!this.columnNames.get(i).equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPrimaryKey(int columnIndex) {
        return columnIndex < this.columnNames.size() && this.columns.get(this.columnNames.get(columnIndex)).isPrimaryKey();
    }

    @Generated
    public Map<String, PhysicalColumnMetaData> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, PhysicalIndexMetaData> getIndexes() {
        return this.indexes;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalTableMetaData)) {
            return false;
        }
        PhysicalTableMetaData other = (PhysicalTableMetaData)o;
        Map<String, PhysicalColumnMetaData> this$columns = this.getColumns();
        Map<String, PhysicalColumnMetaData> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, PhysicalIndexMetaData> this$indexes = this.getIndexes();
        Map<String, PhysicalIndexMetaData> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        List<String> this$columnNames = this.columnNames;
        List<String> other$columnNames = other.columnNames;
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        return !(this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, PhysicalColumnMetaData> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, PhysicalIndexMetaData> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        List<String> $columnNames = this.columnNames;
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PhysicalTableMetaData(columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", columnNames=" + this.columnNames + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
    }
}

