/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<AlterTableStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, AlterTableStatement sqlStatement, TableMetaDataLoaderCallback callback) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        PhysicalSchemaMetaData schemaMetaData = metaData.getSchemaMetaData().getConfiguredSchemaMetaData();
        if (null != schemaMetaData && schemaMetaData.containsTable(tableName)) {
            callback.load(tableName).ifPresent(tableMetaData -> this.alterMetaData(metaData, tableName, (PhysicalTableMetaData)tableMetaData));
        }
    }

    private void alterMetaData(ShardingSphereMetaData metaData, String tableName, PhysicalTableMetaData tableMetaData) {
        metaData.getSchemaMetaData().getConfiguredSchemaMetaData().put(tableName, tableMetaData);
        metaData.getSchemaMetaData().getSchemaMetaData().put(tableName, tableMetaData);
    }
}

