/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<CreateTableStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, CreateTableStatement sqlStatement, TableMetaDataLoaderCallback callback) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        Optional<PhysicalTableMetaData> tableMetaData = callback.load(tableName);
        if (tableMetaData.isPresent()) {
            metaData.getSchemaMetaData().getConfiguredSchemaMetaData().put(tableName, tableMetaData.get());
            metaData.getSchemaMetaData().getSchemaMetaData().put(tableName, tableMetaData.get());
        } else {
            this.refreshUnconfiguredMetaData(metaData, routeDataSourceNames, tableName);
            metaData.getSchemaMetaData().getSchemaMetaData().put(tableName, new PhysicalTableMetaData());
        }
    }

    private void refreshUnconfiguredMetaData(ShardingSphereMetaData metaData, Collection<String> routeDataSourceNames, String tableName) {
        for (String each : routeDataSourceNames) {
            this.refreshUnconfiguredMetaData(metaData, tableName, each);
        }
    }

    private void refreshUnconfiguredMetaData(ShardingSphereMetaData metaData, String tableName, String dataSourceName) {
        Collection<String> schemaMetaData = metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().get(dataSourceName);
        if (null == schemaMetaData) {
            metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().put(dataSourceName, Lists.newArrayList((Object[])new String[]{tableName}));
        } else {
            schemaMetaData.add(tableName);
        }
    }
}

