/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import java.util.Collection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;

public final class DropTableStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<DropTableStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, DropTableStatement sqlStatement, TableMetaDataLoaderCallback callback) {
        sqlStatement.getTables().forEach(each -> this.removeMetaData(metaData, each.getTableName().getIdentifier().getValue(), routeDataSourceNames));
    }

    private void removeMetaData(ShardingSphereMetaData metaData, String tableName, Collection<String> routeDataSourceNames) {
        metaData.getSchemaMetaData().getConfiguredSchemaMetaData().remove(tableName);
        for (String each : routeDataSourceNames) {
            Collection<String> schemaMetaData = metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().get(each);
            if (null == schemaMetaData) continue;
            schemaMetaData.remove(tableName);
        }
        metaData.getSchemaMetaData().getSchemaMetaData().remove(tableName);
    }
}

