/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.TableContainedRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class TableMetaDataBuilder {
    public static Optional<TableMetaData> build(String tableName, SchemaBuilderMaterials materials) throws SQLException {
        Optional<TableMetaData> tableMetaData = TableMetaDataBuilder.load(tableName, materials);
        return tableMetaData.map(optional -> TableMetaDataBuilder.decorate(tableName, optional, materials.getRules()));
    }

    public static Optional<TableMetaData> load(String tableName, SchemaBuilderMaterials materials) throws SQLException {
        DataNodes dataNodes = new DataNodes(materials.getRules());
        for (Map.Entry<ShardingSphereRule, RuleBasedTableMetaDataBuilder> entry : OrderedSPIRegistry.getRegisteredServices(materials.getRules(), RuleBasedTableMetaDataBuilder.class).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            TableContainedRule rule = (TableContainedRule)entry.getKey();
            RuleBasedTableMetaDataBuilder loader = entry.getValue();
            Optional<TableMetaData> result = loader.load(tableName, materials.getDatabaseType(), materials.getDataSourceMap(), dataNodes, rule, materials.getProps());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static TableMetaData decorate(String tableName, TableMetaData tableMetaData, Collection<ShardingSphereRule> rules) {
        TableMetaData result = null;
        for (Map.Entry<ShardingSphereRule, RuleBasedTableMetaDataBuilder> entry : OrderedSPIRegistry.getRegisteredServices(rules, RuleBasedTableMetaDataBuilder.class).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            result = entry.getValue().decorate(tableName, null == result ? tableMetaData : result, (TableContainedRule)entry.getKey());
        }
        return Optional.ofNullable(result).orElse(tableMetaData);
    }

    @Generated
    private TableMetaDataBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(RuleBasedTableMetaDataBuilder.class);
    }
}

