/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.event.CreateTableEvent;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.type.TableContainedRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableStatementSchemaRefresher
implements SchemaRefresher<CreateTableStatement> {
    @Override
    public void refresh(ShardingSphereSchema schema, Collection<String> routeDataSourceNames, CreateTableStatement sqlStatement, SchemaBuilderMaterials materials) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        TableMetaData tableMetaData = this.containsInTableContainedRule(tableName, materials) ? TableMetaDataBuilder.build(tableName, materials).orElse(new TableMetaData()) : this.loadTableMetaData(tableName, routeDataSourceNames, materials);
        schema.put(tableName, tableMetaData);
        ShardingSphereEventBus.getInstance().post((Object)new CreateTableEvent(routeDataSourceNames.iterator().next(), tableName, tableMetaData));
    }

    private boolean containsInTableContainedRule(String tableName, SchemaBuilderMaterials materials) {
        for (ShardingSphereRule each : materials.getRules()) {
            if (!(each instanceof TableContainedRule) || !((TableContainedRule)each).getTables().contains(tableName)) continue;
            return true;
        }
        return false;
    }

    private TableMetaData loadTableMetaData(String tableName, Collection<String> routeDataSourceNames, SchemaBuilderMaterials materials) throws SQLException {
        for (String routeDataSourceName : routeDataSourceNames) {
            Optional tableMetaDataOptional;
            DataSource dataSource = materials.getDataSourceMap().get(routeDataSourceName);
            Optional<Object> optional = tableMetaDataOptional = Objects.isNull(dataSource) ? Optional.empty() : TableMetaDataLoader.load(dataSource, tableName, materials.getDatabaseType());
            if (!tableMetaDataOptional.isPresent()) continue;
            return (TableMetaData)tableMetaDataOptional.get();
        }
        return new TableMetaData();
    }
}

