/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.checker;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class RuleConfigurationCheckerFactory {
    public static RuleConfigurationChecker newInstance(RuleConfiguration config) {
        Map<Class<?>, RuleConfigurationChecker> checkers = OrderedSPIRegistry.getRegisteredServicesByClass(Collections.singleton(config.getClass()), RuleConfigurationChecker.class);
        Preconditions.checkArgument((boolean)checkers.containsKey(config.getClass()), (String)"Can not find rule configuration checker for rule type: `%s`", config.getClass());
        return checkers.get(config.getClass());
    }

    @Generated
    private RuleConfigurationCheckerFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(RuleConfigurationChecker.class);
    }
}

