/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.typed;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.typed.TypedSPI;

public final class TypedSPIRegistry {
    public static <T extends TypedSPI> Optional<T> findRegisteredService(Class<T> typedSPIClass, String type, Properties props) {
        Optional<TypedSPI> serviceInstance = ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().filter(each -> each.getType().equalsIgnoreCase(type)).findFirst();
        if (serviceInstance.isPresent()) {
            TypedSPI result = serviceInstance.get();
            TypedSPIRegistry.convertPropertiesValueType(props, result);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static <T extends TypedSPI> Optional<T> findRegisteredService(Class<T> typedSPIClass) {
        return ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().findFirst();
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> typedSPIClass, String type, Properties props) {
        Optional<T> result = TypedSPIRegistry.findRegisteredService(typedSPIClass, type, props);
        if (result.isPresent()) {
            return (T)((TypedSPI)result.get());
        }
        throw new ServiceProviderNotFoundException(typedSPIClass, type);
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> typedSPIClass) {
        Optional<T> serviceInstance = ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().findFirst();
        if (serviceInstance.isPresent()) {
            return (T)((TypedSPI)serviceInstance.get());
        }
        throw new ServiceProviderNotFoundException(typedSPIClass);
    }

    private static <T extends TypedSPI> void convertPropertiesValueType(Properties props, T service) {
        if (null != props) {
            Properties newProps = new Properties();
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.setProperty(key.toString(), null == value ? null : value.toString())));
            service.setProps(newProps);
        }
    }

    @Generated
    private TypedSPIRegistry() {
    }
}

