/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.swapper;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;
import org.apache.shardingsphere.infra.yaml.config.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;

public final class YamlRuleConfigurationSwapperEngine {
    public Collection<YamlRuleConfiguration> swapToYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return OrderedSPIRegistry.getRegisteredServices(ruleConfigs, YamlRuleConfigurationSwapper.class).entrySet().stream().map(entry -> (YamlRuleConfiguration)((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey())).collect(Collectors.toList());
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        Collection ruleConfigTypes = yamlRuleConfigs.stream().map(YamlRuleConfiguration::getRuleConfigurationType).collect(Collectors.toList());
        for (Map.Entry<Class<?>, YamlRuleConfigurationSwapper> entry : OrderedSPIRegistry.getRegisteredServicesByClass(ruleConfigTypes, YamlRuleConfigurationSwapper.class).entrySet()) {
            result.addAll(this.swapToRuleConfigurations(yamlRuleConfigs, entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs, Class<?> ruleConfigType, YamlRuleConfigurationSwapper swapper) {
        return yamlRuleConfigs.stream().filter(each -> each.getRuleConfigurationType().equals(ruleConfigType)).map(each -> (RuleConfiguration)swapper.swapToObject(each)).collect(Collectors.toList());
    }

    public static Map<String, Class<?>> getYamlShortcuts() {
        Collection<YamlRuleConfigurationSwapper> swappers = ShardingSphereServiceLoader.getSingletonServiceInstances(YamlRuleConfigurationSwapper.class);
        HashMap result = new HashMap(swappers.size(), 1.0f);
        for (YamlRuleConfigurationSwapper each : swappers) {
            Class<?> yamlRuleConfigurationClass = Class.forName(((ParameterizedType)each.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0].getTypeName());
            result.put(String.format("!%s", each.getRuleTagName()), yamlRuleConfigurationClass);
        }
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(YamlRuleConfigurationSwapper.class);
    }
}

