/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import java.util.Collection;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;

public final class CreateViewStatementSchemaRefresher
implements SchemaRefresher<CreateViewStatement> {
    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, Collection<String> logicDataSourceNames, CreateViewStatement sqlStatement, ConfigurationProperties props) {
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        TableMetaData tableMetaData = new TableMetaData();
        schemaMetaData.getSchema().put(viewName, tableMetaData);
        if (!this.containsInDataNodeContainedRule(viewName, schemaMetaData)) {
            schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.addDataNode(viewName, (String)logicDataSourceNames.iterator().next()));
        }
    }

    private boolean containsInDataNodeContainedRule(String tableName, ShardingSphereMetaData schemaMetaData) {
        return schemaMetaData.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().anyMatch(each -> each.getAllTables().contains(tableName));
    }
}

