/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;

public enum SystemSchemaBuilderRule {
    MYSQL_INFORMATION_SCHEMA("MySQL", "information_schema", new HashSet<String>(Arrays.asList("columns", "engines", "parameters", "routines", "schemata", "tables", "views"))),
    MYSQL_MYSQL("MySQL", "mysql", new HashSet<String>(Collections.singleton("db"))),
    MYSQL_PERFORMANCE_SCHEMA("MySQL", "performance_schema", new HashSet<String>(Collections.singleton("accounts"))),
    MYSQL_SYS("MySQL", "sys", new HashSet<String>(Collections.singleton("sys"))),
    MYSQL_SHARDING_SPHERE("MySQL", "shardingsphere", new HashSet<String>(Collections.singleton("sharding_table_statistics"))),
    POSTGRESQL_INFORMATION_SCHEMA("PostgreSQL", "information_schema", new HashSet<String>(Arrays.asList("columns", "tables", "views"))),
    POSTGRESQL_PG_CATALOG("PostgreSQL", "pg_catalog", new HashSet<String>(Arrays.asList("pg_class", "pg_database", "pg_inherits", "pg_tablespace", "pg_trigger"))),
    POSTGRESQL_SHARDING_SPHERE("PostgreSQL", "shardingsphere", new HashSet<String>(Collections.singleton("sharding_table_statistics"))),
    OPEN_GAUSS_INFORMATION_SCHEMA("openGauss", "information_schema", Collections.emptySet()),
    OPEN_GAUSS_PG_CATALOG("openGauss", "pg_catalog", Collections.emptySet()),
    OPEN_GAUSS_BLOCKCHAIN("openGauss", "blockchain", Collections.emptySet()),
    OPEN_GAUSS_CSTORE("openGauss", "cstore", Collections.emptySet()),
    OPEN_GAUSS_DB4AI("openGauss", "db4ai", Collections.emptySet()),
    OPEN_GAUSS_DBE_PERF("openGauss", "dbe_perf", Collections.emptySet()),
    OPEN_GAUSS_DBE_PLDEBUGGER("openGauss", "dbe_pldebugger", Collections.emptySet()),
    OPEN_GAUSS_GAUSSDB("openGauss", "gaussdb", Collections.emptySet()),
    OPEN_GAUSS_ORACLE("openGauss", "oracle", Collections.emptySet()),
    OPEN_GAUSS_PKG_SERVICE("openGauss", "pkg_service", Collections.emptySet()),
    OPEN_GAUSS_SNAPSHOT("openGauss", "snapshot", Collections.emptySet()),
    OPEN_GAUSS_PLDEVELOPER("openGauss", "dbe_pldeveloper", Collections.emptySet()),
    OPEN_GAUSS_PG_TOAST("openGauss", "pg_toast", Collections.emptySet()),
    OPEN_GAUSS_PKG_UTIL("openGauss", "pkg_util", Collections.emptySet()),
    OPEN_GAUSS_SQLADVISOR("openGauss", "sqladvisor", Collections.emptySet()),
    OPEN_GAUSS_SHARDING_SPHERE("openGauss", "shardingsphere", new HashSet<String>(Collections.singleton("sharding_table_statistics")));

    private static final Map<String, SystemSchemaBuilderRule> SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP;
    private final String databaseType;
    private final String schema;
    private final Collection<String> tables;

    public static SystemSchemaBuilderRule valueOf(String databaseType, String schema) {
        String schemaPath = databaseType + "." + schema;
        SystemSchemaBuilderRule result = SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP.get(schemaPath);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Can not find builder rule: `%s`", (Object)schemaPath);
        return result;
    }

    public static boolean isSystemTable(String schema, String tableName) {
        for (SystemSchemaBuilderRule each : SystemSchemaBuilderRule.values()) {
            if (!each.getSchema().equals(schema) || !each.getTables().contains(tableName)) continue;
            return true;
        }
        return false;
    }

    @Generated
    private SystemSchemaBuilderRule(String databaseType, String schema, Collection<String> tables) {
        this.databaseType = databaseType;
        this.schema = schema;
        this.tables = tables;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Collection<String> getTables() {
        return this.tables;
    }

    static {
        SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP = new HashMap<String, SystemSchemaBuilderRule>(SystemSchemaBuilderRule.values().length, 1.0f);
        for (SystemSchemaBuilderRule each : SystemSchemaBuilderRule.values()) {
            SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP.put(each.getDatabaseType() + "." + each.getSchema(), each);
        }
    }
}

