/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.type.SchemaSupportedDatabaseType;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.wrapper.SQLWrapperException;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(String databaseName, DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        return DatabaseTypeEngine.findConfiguredDatabaseType(props).orElseGet(() -> DatabaseTypeEngine.getStorageType(DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, databaseConfig)));
    }

    public static DatabaseType getProtocolType(Map<String, ? extends DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        return configuredDatabaseType.orElseGet(() -> DatabaseTypeEngine.getStorageType(DatabaseTypeEngine.getEnabledDataSources(databaseConfigs).values()));
    }

    private static Map<String, DataSource> getEnabledDataSources(Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, ? extends DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            result.putAll(DataSourceStateManager.getInstance().getEnabledDataSourceMap(entry.getKey(), entry.getValue().getDataSources()));
        }
        return result;
    }

    public static Map<String, DatabaseType> getStorageTypes(String databaseName, DatabaseConfiguration databaseConfig) {
        LinkedHashMap<String, DatabaseType> result = new LinkedHashMap<String, DatabaseType>(databaseConfig.getDataSources().size(), 1.0f);
        Map<String, DataSource> enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSourceMap(databaseName, databaseConfig.getDataSources());
        for (Map.Entry<String, DataSource> entry : enabledDataSources.entrySet()) {
            result.put(entry.getKey(), DatabaseTypeEngine.getStorageType(entry.getValue()));
        }
        return result;
    }

    public static DatabaseType getDatabaseType(String url) {
        return DatabaseTypeFactory.getInstances().stream().filter(each -> DatabaseTypeEngine.matchURLs(url, each)).findAny().orElseGet(() -> DatabaseTypeFactory.getInstance("SQL92"));
    }

    public static DatabaseType getStorageType(Collection<DataSource> dataSources) {
        return dataSources.isEmpty() ? DatabaseTypeFactory.getInstance(DEFAULT_DATABASE_TYPE) : DatabaseTypeEngine.getStorageType(dataSources.iterator().next());
    }

    private static DatabaseType getStorageType(DataSource dataSource) {
        DatabaseType databaseType;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeEngine.getDatabaseType(connection.getMetaData().getURL());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new SQLWrapperException(ex);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        String configuredDatabaseType = (String)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return configuredDatabaseType.isEmpty() ? Optional.empty() : Optional.of(DatabaseTypeEngine.getTrunkDatabaseType(configuredDatabaseType));
    }

    private static boolean matchURLs(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixes().stream().anyMatch(url::startsWith);
    }

    public static DatabaseType getTrunkDatabaseType(String name) {
        DatabaseType databaseType = DatabaseTypeFactory.getInstance(name);
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType() : databaseType;
    }

    public static String getTrunkDatabaseTypeName(DatabaseType databaseType) {
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType().getType() : databaseType.getType();
    }

    public static String getDefaultSchemaName(DatabaseType protocolType, String databaseName) {
        return protocolType instanceof SchemaSupportedDatabaseType ? ((SchemaSupportedDatabaseType)protocolType).getDefaultSchema() : databaseName.toLowerCase();
    }

    public static Optional<String> getDefaultSchemaName(DatabaseType protocolType) {
        return protocolType instanceof SchemaSupportedDatabaseType ? Optional.of(((SchemaSupportedDatabaseType)protocolType).getDefaultSchema()) : Optional.empty();
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

