/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.metadata.type.c3p0;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DefaultDataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.infra.datasource.pool.metadata.type.c3p0.C3P0DataSourcePoolFieldMetaData;

public final class C3P0DataSourcePoolMetaData
implements DataSourcePoolMetaData {
    private static final Map<String, Object> DEFAULT_PROPS = new HashMap<String, Object>(6, 1.0f);
    private static final Map<String, Object> INVALID_PROPS = new HashMap<String, Object>(2, 1.0f);
    private static final Map<String, String> PROP_SYNONYMS = new HashMap<String, String>(5, 1.0f);
    private static final Collection<String> TRANSIENT_FIELD_NAMES = new LinkedList<String>();

    private static void buildDefaultProperties() {
        DEFAULT_PROPS.put("checkoutTimeout", 20000L);
        DEFAULT_PROPS.put("maxIdleTime", 60000L);
        DEFAULT_PROPS.put("maxIdleTimeExcessConnections", 0x200B20L);
        DEFAULT_PROPS.put("maxPoolSize", 15);
        DEFAULT_PROPS.put("minPoolSize", 3);
        DEFAULT_PROPS.put("readOnly", false);
    }

    private static void buildInvalidProperties() {
        INVALID_PROPS.put("minPoolSize", -1);
        INVALID_PROPS.put("maxPoolSize", -1);
    }

    private static void buildPropertySynonyms() {
        PROP_SYNONYMS.put("username", "user");
        PROP_SYNONYMS.put("url", "jdbcUrl");
        PROP_SYNONYMS.put("connectionTimeoutMilliseconds", "checkoutTimeout");
        PROP_SYNONYMS.put("idleTimeoutMilliseconds", "maxIdleTime");
        PROP_SYNONYMS.put("maxLifetimeMilliseconds", "maxIdleTimeExcessConnections");
    }

    private static void buildTransientFieldNames() {
        TRANSIENT_FIELD_NAMES.add("running");
        TRANSIENT_FIELD_NAMES.add("closed");
    }

    @Override
    public Map<String, Object> getDefaultProperties() {
        return DEFAULT_PROPS;
    }

    @Override
    public Map<String, Object> getInvalidProperties() {
        return INVALID_PROPS;
    }

    @Override
    public Map<String, String> getPropertySynonyms() {
        return PROP_SYNONYMS;
    }

    @Override
    public Collection<String> getTransientFieldNames() {
        return TRANSIENT_FIELD_NAMES;
    }

    @Override
    public C3P0DataSourcePoolFieldMetaData getFieldMetaData() {
        return new C3P0DataSourcePoolFieldMetaData();
    }

    public String getType() {
        return "com.mchange.v2.c3p0.ComboPooledDataSource";
    }

    @Override
    public DataSourcePoolPropertiesValidator getDataSourcePoolPropertiesValidator() {
        return new DefaultDataSourcePoolPropertiesValidator();
    }

    static {
        C3P0DataSourcePoolMetaData.buildDefaultProperties();
        C3P0DataSourcePoolMetaData.buildInvalidProperties();
        C3P0DataSourcePoolMetaData.buildPropertySynonyms();
        C3P0DataSourcePoolMetaData.buildTransientFieldNames();
    }
}

