/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataFactory;
import org.apache.shardingsphere.infra.datasource.props.custom.CustomDataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.synonym.ConnectionPropertySynonyms;
import org.apache.shardingsphere.infra.datasource.props.synonym.PoolPropertySynonyms;

public final class DataSourceProperties {
    private final String dataSourceClassName;
    private final ConnectionPropertySynonyms connectionPropertySynonyms;
    private final PoolPropertySynonyms poolPropertySynonyms;
    private final CustomDataSourceProperties customDataSourceProperties;

    public DataSourceProperties(String dataSourceClassName, Map<String, Object> props) {
        this.dataSourceClassName = dataSourceClassName;
        Optional<DataSourcePoolMetaData> poolMetaData = DataSourcePoolMetaDataFactory.findInstance(dataSourceClassName);
        Map<String, String> propertySynonyms = poolMetaData.isPresent() ? poolMetaData.get().getPropertySynonyms() : Collections.emptyMap();
        this.connectionPropertySynonyms = new ConnectionPropertySynonyms(props, propertySynonyms);
        this.poolPropertySynonyms = new PoolPropertySynonyms(props, propertySynonyms);
        this.customDataSourceProperties = new CustomDataSourceProperties(props, this.getStandardPropertyKeys(), poolMetaData.isPresent() ? poolMetaData.get().getTransientFieldNames() : Collections.emptyList(), propertySynonyms);
    }

    private Collection<String> getStandardPropertyKeys() {
        LinkedList<String> result = new LinkedList<String>(this.connectionPropertySynonyms.getStandardPropertyKeys());
        result.addAll(this.poolPropertySynonyms.getStandardPropertyKeys());
        return result;
    }

    public Map<String, Object> getAllStandardProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.connectionPropertySynonyms.getStandardProperties().size() + this.poolPropertySynonyms.getStandardProperties().size() + this.customDataSourceProperties.getProperties().size(), 1.0f);
        result.putAll(this.connectionPropertySynonyms.getStandardProperties());
        result.putAll(this.poolPropertySynonyms.getStandardProperties());
        result.putAll(this.customDataSourceProperties.getProperties());
        return result;
    }

    public Map<String, Object> getAllLocalProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.connectionPropertySynonyms.getLocalProperties().size() + this.poolPropertySynonyms.getLocalProperties().size() + this.customDataSourceProperties.getProperties().size(), 1.0f);
        result.putAll(this.connectionPropertySynonyms.getLocalProperties());
        result.putAll(this.poolPropertySynonyms.getLocalProperties());
        result.putAll(this.customDataSourceProperties.getProperties());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((DataSourceProperties)obj);
    }

    private boolean equalsByProperties(DataSourceProperties dataSourceProps) {
        if (!this.dataSourceClassName.equals(dataSourceProps.dataSourceClassName)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.getAllLocalProperties().entrySet()) {
            if (!dataSourceProps.getAllLocalProperties().containsKey(entry.getKey())) continue;
            if (entry.getValue() instanceof Map) {
                return entry.getValue().equals(dataSourceProps.getAllLocalProperties().get(entry.getKey()));
            }
            if (String.valueOf(entry.getValue()).equals(String.valueOf(dataSourceProps.getAllLocalProperties().get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.getAllLocalProperties().entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue());
        }
        return Objects.hashCode((Object[])new Object[]{this.dataSourceClassName, stringBuilder.toString()});
    }

    @Generated
    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @Generated
    public ConnectionPropertySynonyms getConnectionPropertySynonyms() {
        return this.connectionPropertySynonyms;
    }

    @Generated
    public PoolPropertySynonyms getPoolPropertySynonyms() {
        return this.poolPropertySynonyms;
    }

    @Generated
    public CustomDataSourceProperties getCustomDataSourceProperties() {
        return this.customDataSourceProperties;
    }
}

