/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataFactory;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.InvalidDataSourcePropertiesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;

public final class DataSourcePropertiesValidator {
    public void validate(Map<String, DataSourceProperties> dataSourcePropertiesMap) throws InvalidResourcesException {
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropertiesMap.entrySet()) {
            try {
                this.validateProperties(entry.getKey(), entry.getValue());
                this.validateConnection(entry.getKey(), entry.getValue());
            }
            catch (InvalidDataSourcePropertiesException ex) {
                errorMessages.add(ex.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidResourcesException(errorMessages);
        }
    }

    private void validateProperties(String dataSourceName, DataSourceProperties dataSourceProps) throws InvalidDataSourcePropertiesException {
        Optional<DataSourcePoolMetaData> poolMetaData = DataSourcePoolMetaDataFactory.findInstance(dataSourceProps.getDataSourceClassName());
        if (!poolMetaData.isPresent()) {
            return;
        }
        try {
            DataSourcePoolPropertiesValidator propertiesValidator = poolMetaData.get().getDataSourcePoolPropertiesValidator();
            propertiesValidator.validateProperties(dataSourceProps);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidDataSourcePropertiesException(dataSourceName, ex.getMessage());
        }
    }

    private void validateConnection(String dataSourceName, DataSourceProperties dataSourceProps) throws InvalidDataSourcePropertiesException {
        DataSource dataSource = null;
        try {
            dataSource = DataSourcePoolCreator.create(dataSourceProps);
            this.checkFailFast(dataSource);
        }
        catch (RuntimeException | SQLException ex) {
            throw new InvalidDataSourcePropertiesException(dataSourceName, ex.getMessage());
        }
        finally {
            if (null != dataSource) {
                new DataSourcePoolDestroyer(dataSource).asyncDestroy();
            }
        }
    }

    private void checkFailFast(DataSource dataSource) throws SQLException {
        dataSource.getConnection();
    }
}

