/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Splitter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;

public final class SQLHintUtils {
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_START_HINT_TOKEN = "/* SHARDINGSPHERE_HINT:";
    private static final String SQL_HINT_TOKEN = "shardingsphere_hint:";
    private static final String SQL_HINT_SPLIT = ",";
    private static final String SQL_HINT_VALUE_SPLIT = "=";
    private static final String SQL_HINT_VALUE_COLLECTION_SPLIT = " ";
    private static final int SQL_HINT_VALUE_SIZE = 2;

    public static Properties getSQLHintProps(String comment) {
        Properties result = new Properties();
        int startIndex = comment.toLowerCase().indexOf(SQL_HINT_TOKEN);
        if (startIndex < 0) {
            return result;
        }
        int endIndex = comment.endsWith(SQL_COMMENT_SUFFIX) ? comment.indexOf(SQL_COMMENT_SUFFIX) : comment.length();
        List sqlHints = Splitter.on((String)SQL_HINT_SPLIT).trimResults().splitToList((CharSequence)comment.substring(startIndex += SQL_HINT_TOKEN.length(), endIndex).trim());
        for (String each : sqlHints) {
            List hintValues = Splitter.on((String)SQL_HINT_VALUE_SPLIT).trimResults().splitToList((CharSequence)each);
            if (2 != hintValues.size()) continue;
            result.put(((String)hintValues.get(0)).toUpperCase(), SQLHintUtils.convert((String)hintValues.get(1)));
        }
        return result;
    }

    private static Object convert(String value) {
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static Collection<String> getSplitterSQLHintValue(String value) {
        return value.isEmpty() ? Collections.emptySet() : new HashSet(Splitter.on((String)SQL_HINT_VALUE_COLLECTION_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)value));
    }

    public static HintValueContext extractHint(String sql) {
        HintValueContext result = new HintValueContext();
        if (null == sql || !sql.startsWith(SQL_START_HINT_TOKEN)) {
            return result;
        }
        String hintText = sql.substring(0, sql.indexOf(SQL_COMMENT_SUFFIX) + 2);
        Properties hintProperties = SQLHintUtils.getSQLHintProps(hintText);
        if (hintProperties.containsKey(SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY.getKey())) {
            result.setWriteRouteOnly(Boolean.parseBoolean(hintProperties.getProperty(SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY.getKey())));
        }
        if (hintProperties.containsKey(SQLHintPropertiesKey.USE_TRAFFIC_KEY.getKey())) {
            result.setUseTraffic(Boolean.parseBoolean(hintProperties.getProperty(SQLHintPropertiesKey.USE_TRAFFIC_KEY.getKey())));
        }
        if (hintProperties.containsKey(SQLHintPropertiesKey.SKIP_ENCRYPT_REWRITE_KEY.getKey())) {
            result.setSkipEncryptRewrite(Boolean.parseBoolean(hintProperties.getProperty(SQLHintPropertiesKey.SKIP_ENCRYPT_REWRITE_KEY.getKey())));
        }
        if (hintProperties.containsKey(SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY.getKey())) {
            result.setDisableAuditNames(hintProperties.getProperty(SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY.getKey()));
        }
        if (hintProperties.containsKey(SQLHintPropertiesKey.SHADOW_KEY.getKey())) {
            result.setShadow(Boolean.parseBoolean(hintProperties.getProperty(SQLHintPropertiesKey.SHADOW_KEY.getKey())));
        }
        for (Map.Entry<Object, Object> entry : hintProperties.entrySet()) {
            Object value;
            Object object = value = entry.getValue() instanceof Comparable ? (Comparable)entry.getValue() : Objects.toString(entry.getValue());
            if (Objects.toString(entry.getKey()).contains(SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey())) {
                result.getShardingDatabaseValues().put((Object)Objects.toString(entry.getKey()), value);
            }
            if (!Objects.toString(entry.getKey()).contains(SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey())) continue;
            result.getShardingTableValues().put((Object)Objects.toString(entry.getKey()), value);
        }
        return result;
    }

    public static String removeHint(String sql) {
        if (sql.startsWith(SQL_START_HINT_TOKEN)) {
            return sql.substring(sql.indexOf(SQL_COMMENT_SUFFIX) + 2);
        }
        return sql;
    }

    @Generated
    private SQLHintUtils() {
    }
}

