/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.infra.state.StateType;

public final class ComputeNodeInstance {
    private final InstanceMetaData metaData;
    private final StateContext state = new StateContext();
    private Collection<String> labels = new LinkedList<String>();
    private volatile int workerId;

    public ComputeNodeInstance(InstanceMetaData metaData) {
        this.metaData = metaData;
        this.workerId = -1;
    }

    public void setLabels(Collection<String> labels) {
        if (null != labels) {
            this.labels = labels;
        }
    }

    public void switchState(String status) {
        this.state.switchState(StateType.CIRCUIT_BREAK, StateType.CIRCUIT_BREAK.name().equals(status));
    }

    public String getCurrentInstanceId() {
        return this.metaData.getId();
    }

    @Generated
    public InstanceMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public StateContext getState() {
        return this.state;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public int getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setWorkerId(int workerId) {
        this.workerId = workerId;
    }
}

