/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class ShardingSphereDatabasesFactory {
    public static ShardingSphereDatabase create(String databaseName, DatabaseConfiguration databaseConfig, ConfigurationProperties props, InstanceContext instanceContext) throws SQLException {
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(databaseName, databaseConfig, props);
        Map<String, DatabaseType> storageTypes = DatabaseTypeEngine.getStorageTypes(databaseName, databaseConfig);
        return ShardingSphereDatabase.create(databaseName, protocolType, storageTypes, databaseConfig, props, instanceContext);
    }

    public static Map<String, ShardingSphereDatabase> create(Map<String, DatabaseConfiguration> databaseConfigMap, ConfigurationProperties props, InstanceContext instanceContext) throws SQLException {
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(databaseConfigMap, props);
        ConcurrentHashMap<String, ShardingSphereDatabase> result = new ConcurrentHashMap<String, ShardingSphereDatabase>(databaseConfigMap.size() + protocolType.getSystemDatabaseSchemaMap().size(), 1.0f);
        result.putAll(ShardingSphereDatabasesFactory.createGenericDatabases(databaseConfigMap, protocolType, props, instanceContext));
        result.putAll(ShardingSphereDatabasesFactory.createSystemDatabases(databaseConfigMap, protocolType));
        return result;
    }

    private static Map<String, ShardingSphereDatabase> createGenericDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, ConfigurationProperties props, InstanceContext instanceContext) throws SQLException {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(databaseConfigMap.size(), 1.0f);
        for (Map.Entry<String, DatabaseConfiguration> entry : databaseConfigMap.entrySet()) {
            String databaseName = entry.getKey();
            if (entry.getValue().getDataSources().isEmpty() && protocolType.getSystemSchemas().contains(databaseName)) continue;
            Map<String, DatabaseType> storageTypes = DatabaseTypeEngine.getStorageTypes(entry.getKey(), entry.getValue());
            result.put(databaseName.toLowerCase(), ShardingSphereDatabase.create(databaseName, protocolType, storageTypes, entry.getValue(), props, instanceContext));
        }
        return result;
    }

    private static Map<String, ShardingSphereDatabase> createSystemDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType) {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(protocolType.getSystemDatabaseSchemaMap().size(), 1.0f);
        for (String each : protocolType.getSystemDatabaseSchemaMap().keySet()) {
            if (databaseConfigMap.containsKey(each) && !databaseConfigMap.get(each).getDataSources().isEmpty()) continue;
            result.put(each.toLowerCase(), ShardingSphereDatabase.create(each, protocolType));
        }
        return result;
    }
}

