/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.shardingsphere.infra.database.metadata.dialect.MariaDBDataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.enums.QuoteCharacter;

public final class MariaDBDatabaseType
implements BranchDatabaseType {
    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.BACK_QUOTE;
    }

    @Override
    public Collection<String> getJdbcUrlPrefixes() {
        return Collections.singleton(String.format("jdbc:%s:", this.getType().toLowerCase()));
    }

    @Override
    public MariaDBDataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new MariaDBDataSourceMetaData(url);
    }

    @Override
    public DatabaseType getTrunkDatabaseType() {
        return (DatabaseType)TypedSPIRegistry.getRegisteredService(DatabaseType.class, (String)"MySQL");
    }

    @Override
    public Map<String, Collection<String>> getSystemDatabaseSchemaMap() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<String> getSystemSchemas() {
        return Collections.emptyList();
    }

    public String getType() {
        return "MariaDB";
    }
}

